<?php
/**
 * Secure Photo Serving
 * Serves photos only to authorized users
 */

require_once '../../includes/config.php';
requireLogin();

if (!isset($_GET['file'])) {
    http_response_code(404);
    die('File not specified');
}

$filename = basename($_GET['file']); // Prevent directory traversal
$filepath = __DIR__ . '/photos/' . $filename;

// Check if file exists
if (!file_exists($filepath)) {
    http_response_code(404);
    die('File not found');
}

// Get photo details from database
$stmt = $pdo->prepare("SELECT p.*, a.assessor_id FROM photos p JOIN assessments a ON p.assessment_id = a.id WHERE p.filename = ?");
$stmt->execute([$filename]);
$photo = $stmt->fetch();

if (!$photo) {
    http_response_code(404);
    die('Photo not found in database');
}

// Check user has access (admin, assessor, or viewer role)
// All logged-in users can view photos
// You can add more restrictive checks here if needed

// Serve the file
$mime_type = $photo['mime_type'] ?? mime_content_type($filepath);
$filesize = filesize($filepath);

header('Content-Type: ' . $mime_type);
header('Content-Length: ' . $filesize);
header('Content-Disposition: inline; filename="' . $photo['original_filename'] . '"');
header('Cache-Control: private, max-age=86400'); // Cache for 1 day
header('X-Content-Type-Options: nosniff');

readfile($filepath);
exit;
