<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo isset($pageTitle) ? htmlspecialchars($pageTitle) . ' - ' : ''; ?>Risk Assessment System</title>
    
    <!-- Responsive Framework CSS -->
    <link rel="stylesheet" href="css/responsive-framework.css">
    
    <!-- Dark Theme CSS -->
    <link rel="stylesheet" href="css/theme-dark.css">
    
    <!-- Legacy CSS (for backward compatibility) -->
    <?php if (file_exists(__DIR__ . '/../public/css/style.css')): ?>
    <link rel="stylesheet" href="css/style.css">
    <?php endif; ?>
    
    <!-- Theme Switcher (must load before page renders) -->
    <script src="js/theme-switcher.js"></script>
    
    <!-- Theme Color (updated dynamically by theme switcher) -->
    <meta name="theme-color" content="#667eea">
    
    <style>
        /* Additional styles for old header compatibility */
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .nav-container {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 1rem 2rem;
            max-width: 1400px;
            margin: 0 auto;
        }
        
        .logo {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            color: white;
            text-decoration: none;
            font-size: 1.25rem;
            font-weight: 700;
        }
        
        .logo-icon {
            font-size: 1.5rem;
        }
        
        .nav-menu {
            display: flex;
            list-style: none;
            gap: 0.5rem;
            margin: 0;
            padding: 0;
        }
        
        .nav-link {
            display: block;
            padding: 0.5rem 1rem;
            color: white;
            text-decoration: none;
            border-radius: 0.5rem;
            transition: background 0.2s;
            white-space: nowrap;
        }
        
        .nav-link:hover {
            background: rgba(255, 255, 255, 0.15);
        }
        
        .nav-link.active {
            background: rgba(255, 255, 255, 0.25);
            font-weight: 600;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            color: white;
        }
        
        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 1.1rem;
        }
        
        /* Responsive Navigation */
        @media (max-width: 1200px) {
            .nav-menu {
                flex-wrap: wrap;
            }
        }
        
        @media (max-width: 768px) {
            .nav-container {
                flex-direction: column;
                gap: 1rem;
            }
            
            .nav-menu {
                width: 100%;
                flex-direction: column;
            }
            
            .user-info {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
<?php
// Get custom settings (use functions from config or declare if not exists)
if (!function_exists('getCustomLogo')) {
    function getCustomLogo($pdo) {
        try {
            $stmt = $pdo->prepare("SELECT setting_value FROM system_settings WHERE setting_key = 'logo_filename'");
            $stmt->execute();
            $result = $stmt->fetch();
            
            if ($result && file_exists(__DIR__ . '/../public/uploads/branding/' . $result['setting_value'])) {
                return 'uploads/branding/' . $result['setting_value'];
            }
        } catch (Exception $e) {
            // Table might not exist yet
        }
        return null;
    }
}

if (!function_exists('getSystemName')) {
    function getSystemName($pdo) {
        try {
            $stmt = $pdo->prepare("SELECT setting_value FROM system_settings WHERE setting_key = 'system_name'");
            $stmt->execute();
            $result = $stmt->fetch();
            return $result ? $result['setting_value'] : 'Risk Assessment';
        } catch (Exception $e) {
            return 'Risk Assessment';
        }
    }
}

$customLogo = getCustomLogo($pdo);
$systemName = getSystemName($pdo);
?>
<header class="header">
    <nav class="nav-container">
        <a href="dashboard.php" class="logo">
            <?php if ($customLogo): ?>
                <img src="<?php echo $customLogo; ?>" alt="<?php echo sanitizeOutput($systemName); ?>" 
                     style="max-height: 40px; max-width: 200px; object-fit: contain;">
            <?php else: ?>
                <div class="logo-icon">⚠️</div>
                <span><?php echo sanitizeOutput($systemName); ?></span>
            <?php endif; ?>
        </a>

        <ul class="nav-menu">
            <li><a href="dashboard.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>">📊 Dashboard</a></li>
            <li><a href="assessments.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'assessments.php' ? 'active' : ''; ?>">📋 Assessments</a></li>
            <li><a href="new-assessment.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'new-assessment.php' ? 'active' : ''; ?>">➕ New Assessment</a></li>
            <li><a href="locations.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'locations.php' ? 'active' : ''; ?>">📍 Locations</a></li>
            <?php if ($_SESSION['role'] === 'admin'): ?>
            <li><a href="admin-panel.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'admin-panel.php' ? 'active' : ''; ?>" style="background: rgba(217, 119, 6, 0.1); font-weight: 600;">⚙️ Admin Panel</a></li>
            <li><a href="users.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'users.php' ? 'active' : ''; ?>">👥 Users</a></li>
            <?php endif; ?>
        </ul>

        <div class="user-info">
            <div class="user-avatar"><?php echo strtoupper(substr($_SESSION['full_name'], 0, 1)); ?></div>
            <div>
                <div style="font-weight: 600; color: white;"><?php echo sanitizeOutput($_SESSION['full_name']); ?></div>
                <div style="font-size: 0.85rem; color: rgba(255,255,255,0.9);"><?php echo ucfirst($_SESSION['role']); ?></div>
            </div>
            <a href="logout.php" class="btn btn-secondary" style="margin-left: 1rem; padding: 0.5rem 1rem; background: rgba(255,255,255,0.2); border: none; color: white;">🚪 Logout</a>
        </div>
    </nav>
</header>

<main style="padding: 2rem 0; min-height: calc(100vh - 200px);">
