<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo isset($pageTitle) ? htmlspecialchars($pageTitle) . ' - ' : ''; ?>Risk Assessment System</title>
    
    <!-- Responsive Framework CSS -->
    <link rel="stylesheet" href="css/responsive-framework.css">
    
    <!-- Dark Theme CSS -->
    <link rel="stylesheet" href="css/theme-dark.css">
    
    <!-- Theme Switcher (must load before page renders) -->
    <script src="js/theme-switcher.js"></script>
    
    <!-- Theme Color -->
    <meta name="theme-color" content="#667eea">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
</head>
<body>
    <?php
    // Get system settings (use functions from config or declare if not exists)
    if (!function_exists('getCustomLogo')) {
        function getCustomLogo($pdo) {
            try {
                $stmt = $pdo->prepare("SELECT setting_value FROM system_settings WHERE setting_key = 'logo_filename'");
                $stmt->execute();
                $result = $stmt->fetch();
                if ($result && file_exists(__DIR__ . '/../public/uploads/branding/' . $result['setting_value'])) {
                    return 'uploads/branding/' . $result['setting_value'];
                }
            } catch (Exception $e) {}
            return null;
        }
    }

    if (!function_exists('getSystemName')) {
        function getSystemName($pdo) {
            try {
                $stmt = $pdo->prepare("SELECT setting_value FROM system_settings WHERE setting_key = 'system_name'");
                $stmt->execute();
                $result = $stmt->fetch();
                return $result ? $result['setting_value'] : 'Risk Assessment';
            } catch (Exception $e) {
                return 'Risk Assessment';
            }
        }
    }

    $customLogo = getCustomLogo($pdo);
    $systemName = getSystemName($pdo);
    $currentPage = basename($_SERVER['PHP_SELF']);
    ?>

    <!-- Responsive Navigation -->
    <nav class="navbar">
        <div class="container-fluid">
            <div class="navbar-container">
                <a href="dashboard.php" class="navbar-brand">
                    <?php if ($customLogo): ?>
                        <img src="<?php echo $customLogo; ?>" alt="<?php echo sanitizeOutput($systemName); ?>" style="max-height: 32px;">
                    <?php else: ?>
                        ⚠️ <?php echo sanitizeOutput($systemName); ?>
                    <?php endif; ?>
                </a>

                <button class="navbar-toggle" aria-label="Toggle menu">
                    <span></span><span></span><span></span>
                </button>

                <div class="navbar-menu">
                    <div class="navbar-menu-header">
                        <span style="font-weight: 600;">Menu</span>
                        <button class="navbar-close">&times;</button>
                    </div>

                    <ul class="navbar-nav">
                        <li class="navbar-nav-item">
                            <a href="dashboard.php" class="navbar-nav-link <?php echo $currentPage == 'dashboard.php' ? 'active' : ''; ?>">
                                <span>📊</span><span>Dashboard</span>
                            </a>
                        </li>
                        <li class="navbar-nav-item">
                            <a href="assessments.php" class="navbar-nav-link <?php echo $currentPage == 'assessments.php' ? 'active' : ''; ?>">
                                <span>📋</span><span>Assessments</span>
                            </a>
                        </li>
                        <li class="navbar-nav-item">
                            <a href="new-assessment.php" class="navbar-nav-link <?php echo $currentPage == 'new-assessment.php' ? 'active' : ''; ?>">
                                <span>➕</span><span>New</span>
                            </a>
                        </li>
                        <li class="navbar-nav-item">
                            <a href="locations.php" class="navbar-nav-link <?php echo $currentPage == 'locations.php' ? 'active' : ''; ?>">
                                <span>📍</span><span>Locations</span>
                            </a>
                        </li>
                        <li class="navbar-nav-item">
                            <a href="reports.php" class="navbar-nav-link <?php echo $currentPage == 'reports.php' ? 'active' : ''; ?>">
                                <span>📊</span><span>Reports</span>
                            </a>
                        </li>
                        <?php if ($_SESSION['role'] === 'admin'): ?>
                        <li class="navbar-nav-item">
                            <a href="users.php" class="navbar-nav-link <?php echo $currentPage == 'users.php' ? 'active' : ''; ?>">
                                <span>👥</span><span>Users</span>
                            </a>
                        </li>
                        <li class="navbar-nav-item">
                            <a href="admin-panel.php" class="navbar-nav-link <?php echo $currentPage == 'admin-panel.php' ? 'active' : ''; ?>">
                                <span>⚙️</span><span>Admin</span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <li class="navbar-nav-item">
                            <a href="logout.php" class="navbar-nav-link" style="border-top: 1px solid var(--border-color); margin-top: var(--space-2);">
                                <span>🚪</span><span>Logout</span>
                            </a>
                        </li>
                    </ul>
                </div>

                <div class="hidden block-lg" style="color: white; font-size: var(--text-sm);">
                    👤 <?php echo sanitizeOutput($_SESSION['full_name'] ?? 'User'); ?>
                </div>
            </div>
        </div>
    </nav>

    <div class="navbar-backdrop"></div>

    <main class="main-content" style="padding-top: var(--space-6); padding-bottom: var(--space-8);">
