<?php
require_once '../includes/config.php';
requireLogin();

// Only admins can access
if ($_SESSION['role'] !== 'admin') {
    header('Location: dashboard.php');
    exit;
}

// Get system info
$php_version = phpversion();
$db_version = $pdo->query("SELECT VERSION()")->fetchColumn();
$upload_max = ini_get('upload_max_filesize');
$post_max = ini_get('post_max_size');
$memory_limit = ini_get('memory_limit');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>System Settings - Risk System</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <?php include '../templates/header.php'; ?>

    <div class="container">
        <div class="page-header">
            <div>
                <h1 class="page-title">🔧 System Settings</h1>
                <p class="page-subtitle">Configure system-wide settings and preferences</p>
            </div>
            <a href="admin-panel.php" class="btn btn-secondary">← Back to Admin Panel</a>
        </div>

        <!-- System Information -->
        <div class="card mb-3">
            <div class="card-header">
                <h2 class="card-title">📊 System Information</h2>
            </div>

            <div style="padding: 1.5rem;">
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1.5rem;">
                    <div>
                        <strong style="color: var(--text-muted); display: block; margin-bottom: 0.5rem;">PHP Version</strong>
                        <span style="color: var(--text-primary); font-size: 1.1rem;"><?php echo $php_version; ?></span>
                    </div>
                    <div>
                        <strong style="color: var(--text-muted); display: block; margin-bottom: 0.5rem;">Database Version</strong>
                        <span style="color: var(--text-primary); font-size: 1.1rem;"><?php echo $db_version; ?></span>
                    </div>
                    <div>
                        <strong style="color: var(--text-muted); display: block; margin-bottom: 0.5rem;">Upload Max Size</strong>
                        <span style="color: var(--text-primary); font-size: 1.1rem;"><?php echo $upload_max; ?></span>
                    </div>
                    <div>
                        <strong style="color: var(--text-muted); display: block; margin-bottom: 0.5rem;">POST Max Size</strong>
                        <span style="color: var(--text-primary); font-size: 1.1rem;"><?php echo $post_max; ?></span>
                    </div>
                    <div>
                        <strong style="color: var(--text-muted); display: block; margin-bottom: 0.5rem;">Memory Limit</strong>
                        <span style="color: var(--text-primary); font-size: 1.1rem;"><?php echo $memory_limit; ?></span>
                    </div>
                    <div>
                        <strong style="color: var(--text-muted); display: block; margin-bottom: 0.5rem;">Application Version</strong>
                        <span style="color: var(--text-primary); font-size: 1.1rem;">1.0.0</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Configuration Options -->
        <div class="card mb-3">
            <div class="card-header">
                <h2 class="card-title">⚙️ Configuration Files</h2>
            </div>

            <div style="padding: 1.5rem;">
                <div style="display: flex; flex-direction: column; gap: 1rem;">
                    <div style="padding: 1rem; background: var(--bg-tertiary); border-radius: 8px;">
                        <strong style="color: var(--text-primary);">📄 includes/config.php</strong>
                        <p style="color: var(--text-secondary); margin: 0.5rem 0 0 0;">
                            Database connection, session settings, and application configuration
                        </p>
                        <code style="display: block; margin-top: 0.5rem; color: var(--text-muted); font-size: 0.85rem;">
                            Edit via file system or FTP
                        </code>
                    </div>

                    <div style="padding: 1rem; background: var(--bg-tertiary); border-radius: 8px;">
                        <strong style="color: var(--text-primary);">📄 public/.htaccess</strong>
                        <p style="color: var(--text-secondary); margin: 0.5rem 0 0 0;">
                            Apache configuration, URL rewriting, security settings
                        </p>
                        <code style="display: block; margin-top: 0.5rem; color: var(--text-muted); font-size: 0.85rem;">
                            Edit via file system or FTP
                        </code>
                    </div>
                </div>
            </div>
        </div>

        <!-- Database Tools -->
        <div class="card mb-3">
            <div class="card-header">
                <h2 class="card-title">💾 Database Management</h2>
            </div>

            <div style="padding: 1.5rem;">
                <div style="display: flex; flex-direction: column; gap: 1rem;">
                    <div style="padding: 1rem; background: var(--bg-tertiary); border-radius: 8px; border-left: 4px solid var(--primary);">
                        <strong style="color: var(--text-primary); display: block; margin-bottom: 0.5rem;">📦 Backup Database</strong>
                        <p style="color: var(--text-secondary); margin-bottom: 1rem;">
                            Create a backup of the entire database
                        </p>
                        <code style="display: block; padding: 0.75rem; background: rgba(0,0,0,0.05); border-radius: 4px; margin-bottom: 0.5rem;">
                            mysqldump -u root -p scubatricky_risk > backup_$(date +%Y%m%d).sql
                        </code>
                        <small style="color: var(--text-muted);">Run this command via SSH or phpMyAdmin</small>
                    </div>

                    <div style="padding: 1rem; background: var(--bg-tertiary); border-radius: 8px; border-left: 4px solid #10b981;">
                        <strong style="color: var(--text-primary); display: block; margin-bottom: 0.5rem;">🔄 Restore Database</strong>
                        <p style="color: var(--text-secondary); margin-bottom: 1rem;">
                            Restore database from backup file
                        </p>
                        <code style="display: block; padding: 0.75rem; background: rgba(0,0,0,0.05); border-radius: 4px; margin-bottom: 0.5rem;">
                            mysql -u root -p scubatricky_risk < backup_file.sql
                        </code>
                        <small style="color: var(--text-muted);">⚠️ This will overwrite existing data</small>
                    </div>

                    <div style="padding: 1rem; background: var(--bg-tertiary); border-radius: 8px; border-left: 4px solid #f59e0b;">
                        <strong style="color: var(--text-primary); display: block; margin-bottom: 0.5rem;">🔍 Check Database Size</strong>
                        <p style="color: var(--text-secondary); margin-bottom: 1rem;">
                            View database storage usage
                        </p>
                        <code style="display: block; padding: 0.75rem; background: rgba(0,0,0,0.05); border-radius: 4px;">
                            SELECT table_schema, SUM(data_length + index_length) / 1024 / 1024 AS 'Size (MB)'<br>
                            FROM information_schema.tables<br>
                            WHERE table_schema = 'scubatricky_risk';
                        </code>
                    </div>
                </div>
            </div>
        </div>

        <!-- Maintenance Tasks -->
        <div class="card">
            <div class="card-header">
                <h2 class="card-title">🔨 Maintenance Tasks</h2>
            </div>

            <div style="padding: 1.5rem;">
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem;">
                    <div style="padding: 1rem; background: var(--bg-tertiary); border-radius: 8px; text-align: center;">
                        <div style="font-size: 2rem; margin-bottom: 0.5rem;">🗑️</div>
                        <strong style="color: var(--text-primary);">Clear Session Data</strong>
                        <p style="color: var(--text-muted); font-size: 0.85rem; margin-top: 0.5rem;">
                            Clear PHP sessions
                        </p>
                    </div>

                    <div style="padding: 1rem; background: var(--bg-tertiary); border-radius: 8px; text-align: center;">
                        <div style="font-size: 2rem; margin-bottom: 0.5rem;">📁</div>
                        <strong style="color: var(--text-primary);">Clean Uploads</strong>
                        <p style="color: var(--text-muted); font-size: 0.85rem; margin-top: 0.5rem;">
                            Remove orphaned photos
                        </p>
                    </div>

                    <div style="padding: 1rem; background: var(--bg-tertiary); border-radius: 8px; text-align: center;">
                        <div style="font-size: 2rem; margin-bottom: 0.5rem;">📊</div>
                        <strong style="color: var(--text-primary);">Optimize Tables</strong>
                        <p style="color: var(--text-muted); font-size: 0.85rem; margin-top: 0.5rem;">
                            Optimize database
                        </p>
                    </div>

                    <div style="padding: 1rem; background: var(--bg-tertiary); border-radius: 8px; text-align: center;">
                        <div style="font-size: 2rem; margin-bottom: 0.5rem;">🔐</div>
                        <strong style="color: var(--text-primary);">Security Audit</strong>
                        <p style="color: var(--text-muted); font-size: 0.85rem; margin-top: 0.5rem;">
                            Check permissions
                        </p>
                    </div>
                </div>

                <div style="margin-top: 1.5rem; padding: 1rem; background: #fff3cd; border-left: 4px solid #ffc107; border-radius: 4px;">
                    <strong style="color: #856404;">⚠️ Note:</strong>
                    <p style="color: #856404; margin: 0.5rem 0 0 0;">
                        Advanced maintenance tasks should be performed via command line or phpMyAdmin. 
                        See documentation for detailed instructions.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <script src="js/app.js"></script>
</body>
</html>

<?php include '../templates/footer.php'; ?>
