<?php
require_once '../includes/config.php';
requireLogin();

// Fetch assessments with filters
$location_filter = $_GET['location'] ?? '';
$status_filter = $_GET['status'] ?? '';
$risk_filter = $_GET['risk'] ?? '';

$sql = "
    SELECT a.*, l.location_name, l.city, l.postcode, u.full_name as assessor_name
    FROM assessments a
    JOIN locations l ON a.location_id = l.id
    JOIN users u ON a.assessor_id = u.id
    WHERE 1=1
";

$params = [];

if ($location_filter) {
    $sql .= " AND a.location_id = ?";
    $params[] = $location_filter;
}

if ($status_filter) {
    $sql .= " AND a.status = ?";
    $params[] = $status_filter;
}

if ($risk_filter) {
    $sql .= " AND a.overall_risk_level = ?";
    $params[] = $risk_filter;
}

$sql .= " ORDER BY a.created_at DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$assessments = $stmt->fetchAll();

// Fetch locations for filter
$locations = $pdo->query("SELECT id, location_name FROM locations ORDER BY location_name")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Assessments - Risk Assessment System</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <?php include '../templates/header.php'; ?>

    <div class="container">
        <div class="page-header">
            <div>
                <h1 class="page-title">Risk Assessments</h1>
                <p class="page-subtitle">View and manage all risk assessments</p>
            </div>
            <a href="new-assessment.php" class="btn btn-primary">➕ New Assessment</a>
        </div>

        <!-- Filters -->
        <div class="card mb-3">
            <form method="GET" class="form-row">
                <div class="form-group">
                    <label class="form-label" for="location">Filter by Location</label>
                    <select name="location" id="location" class="form-select" onchange="this.form.submit()">
                        <option value="">All Locations</option>
                        <?php foreach ($locations as $loc): ?>
                            <option value="<?php echo $loc['id']; ?>" <?php echo $location_filter == $loc['id'] ? 'selected' : ''; ?>>
                                <?php echo sanitizeOutput($loc['location_name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label" for="status">Filter by Status</label>
                    <select name="status" id="status" class="form-select" onchange="this.form.submit()">
                        <option value="">All Statuses</option>
                        <option value="draft" <?php echo $status_filter == 'draft' ? 'selected' : ''; ?>>Draft</option>
                        <option value="completed" <?php echo $status_filter == 'completed' ? 'selected' : ''; ?>>Completed</option>
                        <option value="reviewed" <?php echo $status_filter == 'reviewed' ? 'selected' : ''; ?>>Reviewed</option>
                        <option value="archived" <?php echo $status_filter == 'archived' ? 'selected' : ''; ?>>Archived</option>
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label" for="risk">Filter by Risk Level</label>
                    <select name="risk" id="risk" class="form-select" onchange="this.form.submit()">
                        <option value="">All Risk Levels</option>
                        <option value="low" <?php echo $risk_filter == 'low' ? 'selected' : ''; ?>>Low</option>
                        <option value="medium" <?php echo $risk_filter == 'medium' ? 'selected' : ''; ?>>Medium</option>
                        <option value="high" <?php echo $risk_filter == 'high' ? 'selected' : ''; ?>>High</option>
                        <option value="critical" <?php echo $risk_filter == 'critical' ? 'selected' : ''; ?>>Critical</option>
                    </select>
                </div>

                <?php if ($location_filter || $status_filter || $risk_filter): ?>
                    <div class="form-group" style="display: flex; align-items: flex-end;">
                        <a href="assessments.php" class="btn btn-secondary">Clear Filters</a>
                    </div>
                <?php endif; ?>
            </form>
        </div>

        <!-- Assessments Table -->
        <div class="card">
            <div class="card-header">
                <h2 class="card-title">Assessments (<?php echo count($assessments); ?>)</h2>
            </div>

            <?php if (empty($assessments)): ?>
                <div style="text-align: center; padding: 4rem 2rem; color: var(--text-muted);">
                    <div style="font-size: 4rem; margin-bottom: 1rem;">📋</div>
                    <h3 style="margin-bottom: 1rem;">No Assessments Found</h3>
                    <p style="margin-bottom: 2rem;">
                        <?php if ($location_filter || $status_filter || $risk_filter): ?>
                            No assessments match your filters. Try adjusting the filters above.
                        <?php else: ?>
                            Get started by creating your first risk assessment.
                        <?php endif; ?>
                    </p>
                    <a href="new-assessment.php" class="btn btn-primary">Create First Assessment</a>
                </div>
            <?php else: ?>
                <div class="table-container">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Assessment #</th>
                                <th>Location</th>
                                <th>Date</th>
                                <th>Assessor</th>
                                <th>Risk Level</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($assessments as $assessment): ?>
                                <tr>
                                    <td>
                                        <strong><?php echo sanitizeOutput($assessment['assessment_number']); ?></strong>
                                    </td>
                                    <td>
                                        <strong><?php echo sanitizeOutput($assessment['location_name']); ?></strong><br>
                                        <small style="color: var(--text-muted);">
                                            <?php echo sanitizeOutput($assessment['city'] . ', ' . $assessment['postcode']); ?>
                                        </small>
                                    </td>
                                    <td><?php echo date('d/m/Y', strtotime($assessment['assessment_date'])); ?></td>
                                    <td><?php echo sanitizeOutput($assessment['assessor_name']); ?></td>
                                    <td>
                                        <span class="badge badge-<?php echo $assessment['overall_risk_level']; ?>">
                                            <?php echo strtoupper($assessment['overall_risk_level']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-<?php echo $assessment['status']; ?>">
                                            <?php echo strtoupper($assessment['status']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group" style="gap: 0.5rem;">
                                            <a href="view-assessment.php?id=<?php echo $assessment['id']; ?>" 
                                               class="btn btn-secondary" style="padding: 0.5rem 1rem;">
                                                📋 View
                                            </a>
                                            <?php if ($assessment['status'] !== 'archived'): ?>
                                                <a href="edit-assessment.php?id=<?php echo $assessment['id']; ?>" 
                                                   class="btn btn-secondary" style="padding: 0.5rem 1rem;">
                                                    ✏️ Edit
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script src="js/app.js"></script>
</body>
</html>

<?php include '../templates/footer.php'; ?>
