<?php
/**
 * Get PDF Template API
 * Returns template configuration for editing
 */

require_once '../../includes/config.php';
requireLogin();

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(['success' => false, 'error' => 'Template ID required']);
    exit;
}

try {
    $stmt = $pdo->prepare("
        SELECT * FROM pdf_templates WHERE id = ?
    ");
    $stmt->execute([$_GET['id']]);
    $template = $stmt->fetch();
    
    if (!$template) {
        echo json_encode(['success' => false, 'error' => 'Template not found']);
        exit;
    }
    
    echo json_encode([
        'success' => true,
        'template' => $template
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
