<?php
require_once '../../includes/config.php';
requireLogin();

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'Assessment ID required']);
    exit;
}

$assessment_id = (int)$_GET['id'];

try {
    // Fetch assessment details
    $stmt = $pdo->prepare("
        SELECT a.*, l.*, u.full_name as assessor_name, u.email as assessor_email
        FROM assessments a
        JOIN locations l ON a.location_id = l.id
        JOIN users u ON a.assessor_id = u.id
        WHERE a.id = ?
    ");
    $stmt->execute([$assessment_id]);
    $assessment = $stmt->fetch();

    if (!$assessment) {
        echo json_encode(['success' => false, 'message' => 'Assessment not found']);
        exit;
    }

    // Fetch assessment details
    $stmt = $pdo->prepare("
        SELECT ad.*, ri.item_name, ri.description, rc.category_name
        FROM assessment_details ad
        JOIN risk_items ri ON ad.risk_item_id = ri.id
        JOIN risk_categories rc ON ri.category_id = rc.id
        WHERE ad.assessment_id = ?
        ORDER BY rc.display_order, ri.display_order
    ");
    $stmt->execute([$assessment_id]);
    $details = $stmt->fetchAll();

    // Generate PDF using Python script
    $data = json_encode([
        'assessment' => $assessment,
        'details' => $details
    ]);

    $temp_data_file = tempnam(sys_get_temp_dir(), 'assessment_');
    file_put_contents($temp_data_file, $data);

    $output_file = __DIR__ . '/../../reports/assessment_' . $assessment_id . '_' . time() . '.pdf';
    
    $command = "python3 " . __DIR__ . "/generate_pdf.py " . escapeshellarg($temp_data_file) . " " . escapeshellarg($output_file);
    exec($command, $output, $return_var);

    unlink($temp_data_file);

    if ($return_var === 0 && file_exists($output_file)) {
        // Return the PDF file
        header('Content-Type: application/pdf');
        header('Content-Disposition: attachment; filename="risk_assessment_' . $assessment['assessment_number'] . '.pdf"');
        header('Content-Length: ' . filesize($output_file));
        readfile($output_file);
        
        // Log the PDF generation
        $stmt = $pdo->prepare("INSERT INTO audit_log (user_id, action, table_name, record_id, ip_address) VALUES (?, 'generate_pdf', 'assessments', ?, ?)");
        $stmt->execute([$_SESSION['user_id'], $assessment_id, $_SERVER['REMOTE_ADDR']]);
        
        exit;
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to generate PDF']);
    }

} catch (Exception $e) {
    error_log($e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Error generating PDF']);
}
?>
