<?php
/**
 * Enhanced PDF Export API
 * Generates PDFs using custom templates
 */

require_once '../../includes/config.php';
requireLogin();

header('Content-Type: application/json');

if (!isset($_GET['assessment_id'])) {
    echo json_encode(['success' => false, 'error' => 'Assessment ID required']);
    exit;
}

$assessment_id = (int)$_GET['assessment_id'];
$template_id = isset($_GET['template_id']) ? (int)$_GET['template_id'] : null;

try {
    // Verify assessment exists and user has access
    $stmt = $pdo->prepare("SELECT id, assessment_number FROM assessments WHERE id = ?");
    $stmt->execute([$assessment_id]);
    $assessment = $stmt->fetch();
    
    if (!$assessment) {
        throw new Exception('Assessment not found');
    }
    
    // Generate unique filename
    $filename = 'assessment_' . $assessment['assessment_number'] . '_' . date('Ymd_His') . '.pdf';
    $output_path = __DIR__ . '/../../reports/' . $filename;
    
    // Ensure reports directory exists
    $reports_dir = __DIR__ . '/../../reports';
    if (!file_exists($reports_dir)) {
        mkdir($reports_dir, 0755, true);
    }
    
    // Build command
    $python_script = __DIR__ . '/generate_pdf_enhanced.py';
    $cmd = sprintf(
        'python3 %s %s %s %s 2>&1',
        escapeshellarg($python_script),
        escapeshellarg($assessment_id),
        $template_id ? escapeshellarg($template_id) : '""',
        escapeshellarg($output_path)
    );
    
    // Execute Python script
    exec($cmd, $output, $return_code);
    
    $response = json_decode(implode("\n", $output), true);
    
    if ($return_code !== 0 || !$response || !$response['success']) {
        throw new Exception($response['error'] ?? 'PDF generation failed: ' . implode("\n", $output));
    }
    
    // Return success with download URL
    echo json_encode([
        'success' => true,
        'filename' => $filename,
        'download_url' => 'api/download-pdf.php?file=' . urlencode($filename),
        'message' => 'PDF generated successfully'
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
