<?php
/**
 * Report Download Endpoint
 * Securely serves generated HTML reports
 */

require_once '../../includes/config.php';
requireLogin();

if (!isset($_GET['file'])) {
    die('File not specified');
}

$filename = basename($_GET['file']); // Prevent directory traversal
$filepath = __DIR__ . '/../../reports/' . $filename;

// Verify file exists
if (!file_exists($filepath)) {
    http_response_code(404);
    die('File not found');
}

// Verify it's an HTML file
if (pathinfo($filename, PATHINFO_EXTENSION) !== 'html') {
    http_response_code(403);
    die('Invalid file type');
}

// Serve the file for download
header('Content-Type: text/html; charset=utf-8');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Content-Length: ' . filesize($filepath));
header('Cache-Control: private, max-age=0, must-revalidate');
header('Pragma: public');

readfile($filepath);
exit;
