<?php
/**
 * PDF Download Endpoint
 * Securely serves generated PDF reports
 */

require_once '../../includes/config.php';
requireLogin();

if (!isset($_GET['file'])) {
    die('File not specified');
}

$filename = basename($_GET['file']); // Prevent directory traversal
$filepath = __DIR__ . '/../../reports/' . $filename;

// Verify file exists
if (!file_exists($filepath)) {
    http_response_code(404);
    die('File not found');
}

// Verify it's a PDF
if (pathinfo($filename, PATHINFO_EXTENSION) !== 'pdf') {
    http_response_code(403);
    die('Invalid file type');
}

// Serve the file
header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Content-Length: ' . filesize($filepath));
header('Cache-Control: private, max-age=0, must-revalidate');
header('Pragma: public');

readfile($filepath);
exit;
