<?php
// Initialize error reporting and logging
require_once __DIR__ . '/error_handler.php';

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'scubatricky_risk');
define('DB_PASS', '');
define('DB_NAME', 'scubatricky_risk');

// Application Configuration
define('SITE_NAME', 'Supermarket Delivery Risk Assessment');
define('SITE_URL', 'http://localhost/risk-assessment-app');
define('UPLOAD_PATH', __DIR__ . '/../reports/');

// SMTP Email Configuration
define('SMTP_ENABLED', false); // Set to true to enable email sending
define('SMTP_HOST', 'smtp.gmail.com'); // SMTP server address
define('SMTP_PORT', 587); // SMTP port (587 for TLS, 465 for SSL, 25 for non-encrypted)
define('SMTP_ENCRYPTION', 'tls'); // Encryption type: 'tls', 'ssl', or '' for none
define('SMTP_USERNAME', ''); // Your email address
define('SMTP_PASSWORD', ''); // Your email password or app-specific password
define('SMTP_FROM_EMAIL', ''); // From email address (usually same as username)
define('SMTP_FROM_NAME', 'Risk Assessment System'); // From name
define('SMTP_REPLY_TO', ''); // Reply-to email (optional, defaults to from email)
define('SMTP_TIMEOUT', 30); // Connection timeout in seconds

// Email Configuration
define('EMAIL_DEBUG', false); // Enable detailed SMTP debug output
define('EMAIL_MAX_RECIPIENTS', 10); // Maximum recipients per email
define('EMAIL_QUEUE_ENABLED', false); // Enable email queue (requires cron job)
define('EMAIL_LOG_ENABLED', true); // Log all email attempts

// Session Configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 0); // Set to 1 if using HTTPS

session_start();

// Database Connection
try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Helper Functions
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit;
    }
}

function sanitizeOutput($data) {
    return htmlspecialchars($data, ENT_QUOTES, 'UTF-8');
}

function generateToken() {
    return bin2hex(random_bytes(32));
}

function validateCSRF($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

// Load permissions helper functions
require_once __DIR__ . '/permissions.php';
?>
