#!/bin/bash

# ============================================================================
# Header/Footer Auto-Fixer
# Automatically adds missing header/footer includes
# ============================================================================

echo "========================================"
echo "  Header/Footer Auto-Fixer             "
echo "========================================"
echo ""

cd "$(dirname "$0")"

FIXED=0
SKIPPED=0

# Find all PHP files (excluding API, login, logout, special files)
while IFS= read -r file; do
    filename=$(basename "$file")
    
    # Skip certain files
    if [[ "$filename" == "login.php" ]] || [[ "$filename" == "logout.php" ]] || 
       [[ "$filename" == "index.php" ]] || [[ "$filename" == "install.php" ]] ||
       [[ "$filename" == "reset-admin.php" ]]; then
        SKIPPED=$((SKIPPED + 1))
        continue
    fi
    
    NEEDS_FIX=0
    
    # Check if file needs footer
    if ! grep -q "include.*footer" "$file"; then
        NEEDS_FIX=1
    fi
    
    if [ $NEEDS_FIX -eq 1 ]; then
        echo "Fixing: $filename"
        
        # Add footer include at the end if missing
        if ! grep -q "include.*footer" "$file"; then
            # Remove any trailing ?> if exists
            if tail -1 "$file" | grep -q "?>"; then
                # Remove last line
                sed -i '$ d' "$file"
            fi
            
            # Add footer include
            echo "" >> "$file"
            echo "<?php include '../templates/footer.php'; ?>" >> "$file"
            
            echo "  ✓ Added footer include"
        fi
        
        FIXED=$((FIXED + 1))
    fi
    
done < <(find public -name "*.php" -type f | grep -v "/api/" | sort)

echo ""
echo "========================================"
echo "  Summary                               "
echo "========================================"
echo ""
echo "Files fixed: $FIXED"
echo "Files skipped: $SKIPPED"
echo ""

if [ $FIXED -gt 0 ]; then
    echo "✓ Fixed $FIXED file(s)"
    echo ""
    echo "Run check-headers.sh to verify"
else
    echo "No files needed fixing"
fi

echo ""
