# WINDOWS 11 INSTALLATION GUIDE

## 🎯 Overview

Automated installation script for the Risk Assessment System on Windows 11 (also compatible with Windows 10 and Windows Server).

---

## ⚡ Quick Start (Recommended)

### **Simple Installation**

1. **Extract the archive** to a folder
2. **Right-click `INSTALL.bat`**
3. **Select "Run as Administrator"**
4. **Follow the prompts**
5. **Done!** ✅

The installer will automatically:
- ✅ Install PHP 8.2
- ✅ Install MySQL 8.0
- ✅ Configure database
- ✅ Set up the application
- ✅ Create desktop shortcuts

---

## 📋 System Requirements

### **Operating System**
- Windows 11 (64-bit)
- Windows 10 (64-bit)
- Windows Server 2019/2022

### **Hardware**
- **CPU:** Dual-core 2GHz or faster
- **RAM:** 4GB minimum, 8GB recommended
- **Disk:** 2GB free space minimum
- **Network:** Internet connection (for installation)

### **Software**
- Administrator privileges
- PowerShell 5.1 or higher (included in Windows 10/11)
- .NET Framework 4.7.2 or higher (included in Windows 10/11)

---

## 🚀 Installation Methods

### **Method 1: Automated Installer (Recommended)**

**Step-by-step:**

1. **Download** the Risk Assessment System archive
2. **Extract** to `C:\Temp\risk-assessment\` (or any folder)
3. **Right-click** `INSTALL.bat`
4. **Select** "Run as Administrator"
5. **Wait** for installation (10-15 minutes)
6. **Access** the application at `http://localhost:8080`

**Default Credentials:**
```
Username: admin
Password: Admin123!
```

⚠️ **Change the password immediately after first login!**

---

### **Method 2: PowerShell Script**

**For advanced users:**

```powershell
# Open PowerShell as Administrator
# Navigate to the extracted folder
cd C:\Temp\risk-assessment

# Run installer
.\Install-RiskAssessment.ps1
```

**With custom options:**

```powershell
# Custom installation path
.\Install-RiskAssessment.ps1 -InstallPath "D:\WebApps\RiskAssessment"

# Unattended installation
.\Install-RiskAssessment.ps1 -Unattended

# Skip dependency installation
.\Install-RiskAssessment.ps1 -SkipDependencies

# Custom MySQL root password
.\Install-RiskAssessment.ps1 -MySQLRootPassword "YourSecurePassword"
```

---

### **Method 3: Manual Installation**

**If automated installer fails:**

#### **Step 1: Install Dependencies**

**1.1 Install Visual C++ Redistributable**
- Download from: https://aka.ms/vs/17/release/vc_redist.x64.exe
- Run and install

**1.2 Install PHP**
- Download PHP 8.2 from: https://windows.php.net/download/
- Extract to `C:\PHP`
- Copy `php.ini-production` to `php.ini`
- Enable extensions:
  ```ini
  extension=curl
  extension=gd
  extension=mbstring
  extension=mysqli
  extension=pdo_mysql
  extension=openssl
  ```
- Add `C:\PHP` to system PATH

**1.3 Install MySQL**
- Download MySQL 8.0 from: https://dev.mysql.com/downloads/mysql/
- Run installer
- Choose "Developer Default" setup
- Set root password
- Complete installation

#### **Step 2: Configure Database**

```sql
# Open MySQL Command Line Client
CREATE DATABASE risk_assessment;
CREATE USER 'risk_user'@'localhost' IDENTIFIED BY 'secure_password';
GRANT ALL PRIVILEGES ON risk_assessment.* TO 'risk_user'@'localhost';
FLUSH PRIVILEGES;

# Import schema
USE risk_assessment;
SOURCE C:/path/to/risk-system/includes/complete_schema.sql;
```

#### **Step 3: Configure Application**

Edit `includes/config.php`:

```php
define('DB_HOST', 'localhost');
define('DB_USER', 'risk_user');
define('DB_PASS', 'secure_password');
define('DB_NAME', 'risk_assessment');
define('SITE_URL', 'http://localhost:8080');
```

#### **Step 4: Set Permissions**

Create directories and set permissions:
```
risk-system\uploads\  (writable)
risk-system\logs\     (writable)
```

#### **Step 5: Start Server**

```batch
cd C:\path\to\risk-system\public
php -S localhost:8080
```

Access at: `http://localhost:8080`

---

## 🔧 Configuration

### **Installation Options**

The installer creates these files:

```
C:\inetpub\wwwroot\risk-assessment\  (default install path)
├── includes/
│   └── config.php                   (database config)
├── public/                          (web root)
├── uploads/                         (user uploads)
├── logs/                           (application logs)
├── start-server.bat                (server startup)
└── INSTALLATION_INFO.txt           (credentials)
```

### **Database Configuration**

**Auto-generated during installation:**
- Database: `risk_assessment`
- User: `risk_user`
- Password: Random 16-character password (saved in INSTALLATION_INFO.txt)

### **Web Server Options**

**Option A: IIS (If installed)**
- Automatic configuration
- Runs on port 8080
- Windows service (always running)

**Option B: PHP Built-in Server (Default)**
- Manual start/stop
- Runs on port 8080
- Desktop shortcut created: "Risk Assessment Server"

---

## 🌐 Starting the Application

### **Method 1: Desktop Shortcut**

Double-click: **"Risk Assessment Server"** on desktop

### **Method 2: Batch File**

```batch
C:\inetpub\wwwroot\risk-assessment\start-server.bat
```

### **Method 3: PowerShell**

```powershell
cd C:\inetpub\wwwroot\risk-assessment\public
php -S localhost:8080
```

### **Method 4: IIS (if configured)**

Service runs automatically. Access at: `http://localhost:8080`

---

## 🔍 Troubleshooting

### **"Access Denied" Error**

**Solution:** Run installer as Administrator
```
Right-click INSTALL.bat → "Run as Administrator"
```

### **"Port Already in Use"**

**Problem:** Port 8080 is already occupied

**Solution 1:** Stop conflicting service
```powershell
# Find process using port 8080
netstat -ano | findstr :8080

# Stop process (replace PID)
taskkill /PID [PID] /F
```

**Solution 2:** Use different port
```batch
php -S localhost:8081
```

### **"PHP Not Found"**

**Solution:** Add PHP to PATH
```
1. Search "Environment Variables"
2. Edit "System variables" → "Path"
3. Add: C:\PHP
4. Restart PowerShell/Command Prompt
```

### **"MySQL Connection Failed"**

**Check:**
1. MySQL service is running:
   ```
   services.msc → Find "MySQL80" → Start
   ```

2. Database credentials in `config.php`

3. MySQL port (3306) is accessible:
   ```powershell
   Test-NetConnection -ComputerName localhost -Port 3306
   ```

### **"Cannot Create Database"**

**Solution:** Run SQL manually
```sql
# Open MySQL Command Line Client
mysql -u root -p

# Enter root password
CREATE DATABASE risk_assessment;
GRANT ALL ON risk_assessment.* TO 'risk_user'@'localhost';
```

### **Firewall Blocking Access**

**Solution:** Allow port through Windows Firewall
```powershell
New-NetFirewallRule -DisplayName "Risk Assessment" `
  -Direction Inbound -LocalPort 8080 -Protocol TCP -Action Allow
```

### **"Installation Incomplete"**

**Check log file:**
```
C:\Users\[Username]\AppData\Local\Temp\RiskAssessmentInstaller\install.log
```

---

## 📊 Post-Installation

### **First Login**

1. Open browser to `http://localhost:8080`
2. Login with:
   - Username: `admin`
   - Password: `Admin123!`
3. **IMMEDIATELY change password:**
   - Click "Users"
   - Edit Admin user
   - Change password

### **Initial Configuration**

1. **System Settings**
   - Admin Panel → System Customization
   - Upload logo
   - Set company name

2. **SMTP Email**
   - Admin Panel → SMTP Settings
   - Configure email server

3. **Add Locations**
   - Locations → Add New Location
   - Enter store/site details

4. **Create Users**
   - Users → Add User
   - Set roles and permissions

### **Security Hardening**

**1. Change Default Password**
```
Users → Edit Admin → Change Password
```

**2. Secure Config File**
```
Set read-only: includes\config.php
```

**3. Delete Installation Info**
```
Delete: INSTALLATION_INFO.txt (after noting credentials)
```

**4. Enable HTTPS** (Production)
```
Obtain SSL certificate
Configure in IIS or reverse proxy
```

**5. Regular Backups**
```batch
REM Backup database
mysqldump -u risk_user -p risk_assessment > backup.sql

REM Backup files
xcopy /E /I C:\inetpub\wwwroot\risk-assessment C:\Backups\risk-assessment
```

---

## 🔄 Updating

### **Update Application**

1. **Stop server**
2. **Backup files and database**
3. **Extract new version**
4. **Copy to installation directory** (overwrite)
5. **Run migrations** (if any)
6. **Restart server**

### **Update PHP**

1. **Download new version**
2. **Extract to C:\PHP** (replace files)
3. **Verify extensions** in php.ini
4. **Restart server**

### **Update MySQL**

Use MySQL Installer to update components

---

## 🗑️ Uninstallation

### **Remove Application**

1. **Stop server**
2. **Backup data** (if needed)
3. **Delete installation folder:**
   ```
   C:\inetpub\wwwroot\risk-assessment\
   ```
4. **Remove database:**
   ```sql
   DROP DATABASE risk_assessment;
   DROP USER 'risk_user'@'localhost';
   ```

### **Remove Dependencies**

**PHP:**
```
Delete: C:\PHP
Remove from PATH
```

**MySQL:**
```
Control Panel → Uninstall Programs → MySQL Server
```

---

## 📞 Support

### **Log Files**
```
Application: C:\inetpub\wwwroot\risk-assessment\logs\
Installation: %TEMP%\RiskAssessmentInstaller\install.log
MySQL: C:\ProgramData\MySQL\MySQL Server 8.0\Data\
```

### **Common Files**
```
Config:       includes\config.php
Database:     includes\complete_schema.sql
Server Start: start-server.bat
Credentials:  INSTALLATION_INFO.txt
```

### **Get Help**
1. Check installation log
2. Verify all services running
3. Test database connection
4. Review error logs
5. Consult documentation in `docs\` folder

---

## ✅ Installation Checklist

**Before Installation:**
- [ ] Windows 11/10 64-bit
- [ ] Administrator access
- [ ] 2GB free disk space
- [ ] Internet connection

**Installation Steps:**
- [ ] Extract archive
- [ ] Run INSTALL.bat as Administrator
- [ ] Wait for completion
- [ ] Note generated passwords
- [ ] Test application access

**Post-Installation:**
- [ ] Login successful
- [ ] Change admin password
- [ ] Configure SMTP (optional)
- [ ] Add first location
- [ ] Create test assessment
- [ ] Backup INSTALLATION_INFO.txt
- [ ] Delete INSTALLATION_INFO.txt (after backup)

---

## 🎯 Quick Reference

**Start Server:**
```batch
C:\inetpub\wwwroot\risk-assessment\start-server.bat
```

**Access Application:**
```
http://localhost:8080
```

**Default Login:**
```
Username: admin
Password: Admin123!
```

**Database Access:**
```
Host: localhost
Port: 3306
Database: risk_assessment
```

**Installation Path:**
```
C:\inetpub\wwwroot\risk-assessment\
```

---

## 🚀 Next Steps

After successful installation:

1. ✅ Change default password
2. ✅ Configure locations
3. ✅ Create user accounts
4. ✅ Perform test assessment
5. ✅ Configure email settings
6. ✅ Set up regular backups
7. ✅ Review security settings

**Your Risk Assessment System is ready to use!** 🎉
