# LOGIN TROUBLESHOOTING GUIDE

## 🚨 Cannot Login - Quick Fix

### Use the Diagnostic Tool (Easiest)

**Web Interface:**
```
http://yoursite.com/public/test-password.php
```
This tool will:
- Show admin user status
- Test passwords
- Reset password with one click
- Verify everything works

**Command Line:**
```bash
cd /path/to/risk-system
php includes/test-password.php
```

**Automated Script:**
```bash
cd /path/to/risk-system
./diagnose-login.sh
```

---

## 🎯 Default Login Credentials

```
Username: admin
Password: Admin123!
```

**⚠️ Change this immediately after first login!**

---

## 🔧 Manual Password Reset

### Method 1: Direct SQL (Fastest)
```sql
-- Sets password to: Admin123!
UPDATE users 
SET password = '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi'
WHERE username = 'admin';
```

### Method 2: Generate Custom Hash
```bash
# Generate hash
php -r "echo password_hash('YourPassword', PASSWORD_DEFAULT) . PHP_EOL;"

# Use in SQL
UPDATE users SET password = 'YOUR_HASH_HERE' WHERE username = 'admin';
```

---

## 📋 Common Issues

### Issue: "Invalid username or password"
**Fix:** Reset password using test-password.php

### Issue: "Column 'password_hash' not found"  
**Fix:** Download latest archive from this session (all files fixed)

### Issue: Admin user doesn't exist
**Fix:** Run diagnostic tool - it will create the user

### Issue: Account inactive
**Fix:** `UPDATE users SET is_active = 1 WHERE username = 'admin';`

---

## 🧪 Verify Everything Works

```bash
# Run diagnostic
./diagnose-login.sh

# Or manually check
php -r "
require_once 'includes/config.php';
\$stmt = \$pdo->prepare('SELECT * FROM users WHERE username = ?');
\$stmt->execute(['admin']);
\$user = \$stmt->fetch();
echo 'User: ' . \$user['username'] . PHP_EOL;
echo 'Active: ' . (\$user['is_active'] ? 'Yes' : 'No') . PHP_EOL;
echo 'Hash: ' . substr(\$user['password'], 0, 20) . '...' . PHP_EOL;
\$match = password_verify('Admin123!', \$user['password']);
echo 'Password OK: ' . (\$match ? 'YES' : 'NO') . PHP_EOL;
"
```

---

## 🆘 Still Having Issues?

1. Check browser console (F12) for JavaScript errors
2. Check PHP error log for server errors
3. Try incognito/private window
4. Clear browser cookies
5. Verify database connection in config.php

---

## 🔒 After Login

1. Change default password immediately
2. Delete these files:
   - public/test-password.php
   - public/reset-admin.php  
   - includes/test-password.php
3. Create additional users with strong passwords

---

For detailed troubleshooting, see the diagnostic tools included in this package.
