# AUTOMATED REPORT EMAIL SYSTEM

## 🎯 Overview

The Risk Assessment System now supports automated email distribution of reports for each location/store. Store managers and stakeholders can receive automatic updates about risk assessments.

---

## 📧 Features

### **Per-Location Email Configuration**

Each store/location can have:
- ✅ Multiple email recipients (comma-separated)
- ✅ Configurable frequency (immediate, daily, weekly, monthly)
- ✅ Enable/disable toggle
- ✅ Last sent timestamp tracking
- ✅ Independent settings per location

---

## 🔧 Setup

### **1. Database Migration**

Run the migration to add email fields to locations table:

```bash
mysql -u user -p database < includes/migration_location_emails.sql
```

**What it adds:**
- `report_emails` - TEXT field for comma-separated emails
- `email_frequency` - ENUM for frequency selection
- `last_report_sent` - Timestamp of last email
- `email_enabled` - Boolean to enable/disable

### **2. Configure Store Emails**

**Access:**
```
Locations → View Location → Edit
OR
Locations → Edit Location
```

**Configuration Section:**
```
📧 Automated Report Emails
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

Report Email Recipients:
┌─────────────────────────────────────────────┐
│ manager@store.com, safety@company.com,      │
│ supervisor@store.com                         │
└─────────────────────────────────────────────┘

Email Frequency: [Daily Digest        ▼]

Automated Reports Status:
☑ Enable automated email reports

Last sent: 08 Jan 2026 10:30
```

---

## ⚙️ Configuration Options

### **Email Frequency**

**None - Manual Only**
- No automated emails
- Reports sent only manually
- Default setting

**Immediate - After Each Assessment**
- Email sent immediately after assessment completed
- Best for: High-priority locations, critical sites
- Each assessment triggers one email

**Daily Digest**
- One email per day with all assessments
- Best for: Regular monitoring, busy locations
- Sent at end of day (configurable time)

**Weekly Summary**
- One email per week summarizing all assessments
- Best for: Lower-priority locations, overview needs
- Sent every Monday (configurable day)

**Monthly Report**
- One comprehensive email per month
- Best for: Management reporting, long-term tracking
- Sent on 1st of each month (configurable date)

### **Email Recipients**

**Format:**
```
email1@example.com, email2@example.com, email3@example.com
```

**Rules:**
- ✅ Multiple emails separated by commas
- ✅ Spaces are trimmed automatically
- ✅ Each email validated before sending
- ✅ Invalid emails logged and skipped
- ✅ No limit on number of recipients

**Examples:**
```
Single recipient:
store.manager@company.com

Multiple recipients:
manager@store.com, safety@company.com, regional@company.com

Department aliases:
safety-team@company.com, operations-team@company.com
```

### **Enable/Disable Toggle**

**Enabled:**
- ✓ Automated emails will be sent per schedule
- ✓ System checks for new assessments
- ✓ Emails sent based on frequency

**Disabled:**
- ○ No automated emails sent
- ○ Manual sending still available
- ○ Configuration preserved (can re-enable anytime)

---

## 📊 Email Content

### **Immediate Email (After Assessment)**

```
Subject: Risk Assessment Complete - [Store Name]

Dear Team,

A risk assessment has been completed for [Store Name]:

Assessment Number: RA-2026-ABC123
Date: 08 Jan 2026 14:30
Assessor: John Smith
Overall Risk Level: MEDIUM RISK

Summary:
- Total Risk Items: 12
- High Risk Items: 2
- Medium Risk Items: 5
- Low Risk Items: 5

Action Items: 3 pending actions

View full assessment:
[Link to assessment]

View action items:
[Link to action items report]

---
This is an automated message from the Risk Assessment System.
```

### **Daily Digest Email**

```
Subject: Daily Risk Assessment Digest - [Store Name] - 08 Jan 2026

Dear Team,

Here's your daily summary of risk assessments for [Store Name]:

Total Assessments Today: 3

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

Assessment #1: RA-2026-ABC123
Time: 09:30
Assessor: John Smith
Risk Level: HIGH RISK
Action Items: 5
[View Assessment]

Assessment #2: RA-2026-ABC124
Time: 13:15
Assessor: Jane Doe
Risk Level: MEDIUM RISK
Action Items: 2
[View Assessment]

Assessment #3: RA-2026-ABC125
Time: 16:45
Assessor: John Smith
Risk Level: LOW RISK
Action Items: 0
[View Assessment]

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

Pending Action Items: 7 total
[View All Action Items]

---
This is an automated message from the Risk Assessment System.
```

### **Weekly Summary Email**

```
Subject: Weekly Risk Assessment Summary - [Store Name] - Week 02, 2026

Dear Team,

Here's your weekly summary for [Store Name]:

Period: 06 Jan 2026 - 12 Jan 2026

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📊 Statistics:
- Total Assessments: 15
- High Risk: 3
- Medium Risk: 8
- Low Risk: 4
- Total Action Items: 12
- Overdue Actions: 2

📈 Trends:
- Risk level compared to last week: ↓ Improved
- Assessments compared to last week: → Same
- Action items compared to last week: ↑ Increased

⚠️ Attention Required:
- 2 overdue action items
- 5 actions due this week

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

[View Full Report]
[View Action Items]
[View All Assessments]

---
This is an automated message from the Risk Assessment System.
```

### **Monthly Report Email**

```
Subject: Monthly Risk Assessment Report - [Store Name] - January 2026

Dear Team,

Here's your monthly report for [Store Name]:

Period: 01 Jan 2026 - 31 Jan 2026

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

📊 Monthly Statistics:
- Total Assessments: 62
- High Risk: 8 (12.9%)
- Medium Risk: 35 (56.5%)
- Low Risk: 19 (30.6%)

📋 Action Items:
- Created: 45
- Completed: 38
- Pending: 7
- Overdue: 1

📈 Performance:
- Average time to complete actions: 5.2 days
- Assessment compliance: 95%
- High-risk items addressed: 100%

🎯 Top Risk Categories:
1. Access & Egress: 18 items
2. Vehicle Movements: 15 items
3. Loading Operations: 12 items

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

[Download Full Report (PDF)]
[View Action Items]
[View All Assessments]

---
This is an automated message from the Risk Assessment System.
```

---

## 🔍 Viewing Email Settings

### **In Location List**

Each location shows email status:
```
📍 Store Name - London
Last Assessment: 2 days ago
📧 Automated Reports: ✓ Enabled (Daily)
```

### **In Location Details**

Full email configuration displayed:
```
📧 Automated Report Emails
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

Status: ✓ Enabled

Recipients:
• manager@store.com
• safety@company.com
• supervisor@store.com

Frequency: Daily Digest

Last sent: 08 Jan 2026 10:30
```

---

## 🔧 Implementation Notes

### **Database Fields**

```sql
report_emails TEXT
-- Stores: "email1@example.com, email2@example.com"

email_frequency ENUM('immediate', 'daily', 'weekly', 'monthly', 'none')
-- Default: 'none'

last_report_sent TIMESTAMP NULL
-- Auto-updated when email sent

email_enabled BOOLEAN
-- Default: FALSE
```

### **Email Validation**

System validates:
- ✅ Valid email format
- ✅ Domain exists (optional DNS check)
- ✅ Not blacklisted
- ✅ Deliverable (optional SMTP check)

### **Error Handling**

If email fails:
- ✅ Logged to error log
- ✅ Marked as failed delivery
- ✅ Retry attempted (configurable)
- ✅ Admin notification (optional)

### **Scheduling**

Emails sent by:
- ✅ Cron job (recommended)
- ✅ Background worker
- ✅ Queue system
- ✅ Scheduled task

---

## 💡 Best Practices

### **Email Recipients**

**Do:**
- ✅ Use department aliases (safety-team@company.com)
- ✅ Include backup contacts
- ✅ Test with one recipient first
- ✅ Update when staff changes

**Don't:**
- ❌ Use personal emails for business reports
- ❌ Include too many recipients (max 10 recommended)
- ❌ Forget to remove old employees
- ❌ Use unmonitored mailboxes

### **Frequency Selection**

**Choose based on:**
- Assessment volume (high → daily/weekly)
- Location priority (critical → immediate)
- Recipient preference (managers → daily, executives → weekly)
- Urgency requirements (safety issues → immediate)

### **Content Management**

**Tips:**
- Keep subject lines clear and searchable
- Include direct links to assessments
- Highlight action items
- Use consistent formatting
- Add unsubscribe option (compliance)

---

## 🚀 Quick Start Guide

### **Step 1: Enable for a Location**

```
1. Go to Locations
2. Click Edit on a location
3. Scroll to "📧 Automated Report Emails"
4. Enter email addresses (comma-separated)
5. Select frequency
6. Check "Enable automated email reports"
7. Save
```

### **Step 2: Test Email**

```
1. Complete an assessment for that location
2. If frequency is "Immediate", email sent now
3. If other frequency, email queued
4. Check "Last sent" timestamp updates
```

### **Step 3: Monitor**

```
1. View location details
2. Check "Last sent" timestamp
3. Verify recipients received email
4. Review email logs if issues
```

---

## ✅ Summary

**Features:**
- ✅ Per-location email configuration
- ✅ Multiple recipients supported
- ✅ Four frequency options
- ✅ Enable/disable toggle
- ✅ Last sent tracking
- ✅ Professional email templates

**Access:**
- Edit location → Automated Report Emails section
- View location → Email settings displayed

**Ready to use:**
- Run migration SQL
- Configure emails per location
- Enable automated reports
- Done!

**Start automating your risk assessment report distribution now!** 📧✨
