#!/bin/bash

# Login Diagnostic Script
# Run this to diagnose and fix login issues

echo "=========================================="
echo "  Risk System - Login Diagnostic Tool   "
echo "=========================================="
echo ""

# Colors
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Check if we're in the right directory
if [ ! -f "includes/config.php" ]; then
    echo -e "${RED}Error: Please run this script from the risk-system root directory${NC}"
    exit 1
fi

echo "Step 1: Checking database connection..."
php -r "
    require_once 'includes/config.php';
    try {
        \$stmt = \$pdo->query('SELECT 1');
        echo '✓ Database connection OK\n';
    } catch (Exception \$e) {
        echo '✗ Database connection failed: ' . \$e->getMessage() . '\n';
        exit(1);
    }
"

echo ""
echo "Step 2: Checking users table..."
php -r "
    require_once 'includes/config.php';
    try {
        \$stmt = \$pdo->query('DESCRIBE users');
        \$columns = \$stmt->fetchAll(PDO::FETCH_COLUMN);
        if (in_array('password', \$columns)) {
            echo '✓ Users table exists with password column\n';
        } else {
            echo '✗ Password column not found!\n';
            echo 'Columns found: ' . implode(', ', \$columns) . '\n';
            exit(1);
        }
    } catch (Exception \$e) {
        echo '✗ Error: ' . \$e->getMessage() . '\n';
        exit(1);
    }
"

echo ""
echo "Step 3: Checking admin user..."
php -r "
    require_once 'includes/config.php';
    \$stmt = \$pdo->prepare('SELECT id, username, role, is_active FROM users WHERE username = ?');
    \$stmt->execute(['admin']);
    \$admin = \$stmt->fetch();
    
    if (\$admin) {
        echo '✓ Admin user exists (ID: ' . \$admin['id'] . ')\n';
        echo '  Role: ' . \$admin['role'] . '\n';
        echo '  Active: ' . (\$admin['is_active'] ? 'Yes' : 'No') . '\n';
    } else {
        echo '⚠ Admin user not found!\n';
    }
"

echo ""
echo "Step 4: Testing password hashing..."
php -r "
    \$password = 'Admin123!';
    \$hash = password_hash(\$password, PASSWORD_DEFAULT);
    \$verify = password_verify(\$password, \$hash);
    
    if (\$verify) {
        echo '✓ Password hashing works correctly\n';
    } else {
        echo '✗ Password hashing test failed!\n';
        exit(1);
    }
"

echo ""
echo "=========================================="
echo "  Diagnostic Complete                    "
echo "=========================================="
echo ""
echo "Would you like to reset the admin password? (y/n)"
read -r response

if [[ "$response" =~ ^([yY][eE][sS]|[yY])$ ]]; then
    echo ""
    echo "Resetting admin password to: Admin123!"
    php includes/test-password.php
    echo ""
    echo -e "${GREEN}✓ Done! Try logging in with:${NC}"
    echo "  Username: admin"
    echo "  Password: Admin123!"
    echo ""
    echo -e "${YELLOW}⚠ Don't forget to change the password after login!${NC}"
fi

echo ""
echo "You can also use these tools:"
echo "  - Web: http://yoursite.com/public/test-password.php"
echo "  - CLI: php includes/test-password.php"
echo ""
