# WINDOWS INSTALLER

## 🚀 Quick Start

### **3 Easy Steps:**

1. **Right-click** `INSTALL.bat`
2. **Select** "Run as Administrator"
3. **Wait** for completion

That's it! 🎉

---

## 📋 What Gets Installed

The automated installer will:

✅ **Install PHP 8.2** - Web server runtime
✅ **Install MySQL 8.0** - Database server  
✅ **Configure Database** - Create database and user
✅ **Deploy Application** - Extract and configure files
✅ **Set Permissions** - Configure file access
✅ **Create Shortcuts** - Desktop launcher

**Total Time:** 10-15 minutes

---

## 🔐 Default Credentials

After installation completes:

```
Application URL: http://localhost:8080

Username: admin
Password: Admin123!

⚠️ CHANGE PASSWORD AFTER FIRST LOGIN!
```

---

## 📁 Files Included

```
INSTALL.bat                    ← Run this as Administrator
Install-RiskAssessment.ps1    ← PowerShell installer script
risk-system-responsive.tar.gz  ← Application files
README.md                      ← This file
docs/
  └── WINDOWS_INSTALLATION_GUIDE.md ← Detailed guide
```

---

## ⚙️ System Requirements

**Operating System:**
- Windows 11 (64-bit) ✅
- Windows 10 (64-bit) ✅  
- Windows Server 2019+ ✅

**Hardware:**
- CPU: 2GHz dual-core minimum
- RAM: 4GB minimum (8GB recommended)
- Disk: 2GB free space
- Network: Internet connection

**Permissions:**
- Administrator access required

---

## 🔧 Installation Options

### **Default Installation**
```batch
Run INSTALL.bat as Administrator
```

### **Custom Installation Path**
```powershell
.\Install-RiskAssessment.ps1 -InstallPath "D:\MyApps\RiskAssessment"
```

### **Unattended Mode**
```powershell
.\Install-RiskAssessment.ps1 -Unattended
```

### **Skip Dependencies**
```powershell
.\Install-RiskAssessment.ps1 -SkipDependencies
```

---

## 📊 What Happens During Installation

**Phase 1: Pre-checks** (5%)
- Verify Windows version
- Check administrator rights
- Verify disk space
- Test internet connection

**Phase 2: Dependencies** (10-60%)
- Download Visual C++ Redistributable
- Download and install PHP 8.2
- Download and install MySQL 8.0
- Configure PATH variables

**Phase 3: Application** (60-85%)
- Extract application files
- Create database and user
- Import database schema
- Update configuration files
- Set file permissions

**Phase 4: Web Server** (85-95%)
- Configure IIS (if available) OR
- Setup PHP built-in server
- Create startup scripts
- Create desktop shortcuts

**Phase 5: Finalization** (95-100%)
- Generate credentials
- Save configuration
- Create documentation
- Display summary

---

## ✅ Success Indicators

Installation completed successfully when you see:

```
============================================================================
  Installation Complete!
============================================================================

📦 INSTALLATION SUMMARY

🌐 Application URL:
   http://localhost:8080

🔐 Default Login Credentials:
   Username: admin
   Password: Admin123!

✅ Installation completed successfully!
```

---

## 🚀 Starting the Application

### **Method 1: Desktop Shortcut**
Double-click: **"Risk Assessment Server"**

### **Method 2: Batch File**
Run: `C:\inetpub\wwwroot\risk-assessment\start-server.bat`

### **Method 3: Command Line**
```batch
cd C:\inetpub\wwwroot\risk-assessment\public
php -S localhost:8080
```

Then open browser to: `http://localhost:8080`

---

## ❌ Troubleshooting

### **"Access Denied"**
→ Right-click INSTALL.bat → "Run as Administrator"

### **"Port 8080 Already in Use"**
→ Stop conflicting service or use different port:
```batch
php -S localhost:8081
```

### **"PHP Not Found"**
→ Close and reopen Command Prompt (PATH updated)

### **Installation Failed**
→ Check log: `%TEMP%\RiskAssessmentInstaller\install.log`

### **Database Connection Error**
→ Check credentials in: `includes\config.php`

---

## 📚 Documentation

Detailed guides available:

- **Installation:** `docs\WINDOWS_INSTALLATION_GUIDE.md`
- **User Guide:** `README.md`
- **Troubleshooting:** `docs\LOGIN_TROUBLESHOOTING.md`
- **Configuration:** `docs\SMTP_CONFIGURATION_GUIDE.md`

---

## 🔐 Security Notes

**After Installation:**

1. ✅ **Change default password immediately**
2. ✅ **Review and secure config.php**
3. ✅ **Delete INSTALLATION_INFO.txt** (after backup)
4. ✅ **Set up HTTPS** (for production)
5. ✅ **Configure firewall rules**
6. ✅ **Enable regular backups**

---

## 📞 Support

**Log Files:**
```
Installation: %TEMP%\RiskAssessmentInstaller\install.log
Application: C:\inetpub\wwwroot\risk-assessment\logs\
```

**Configuration:**
```
Database: includes\config.php
Server: start-server.bat
```

**Credentials:**
```
Saved in: INSTALLATION_INFO.txt
```

---

## 🎯 Quick Reference Card

| Item | Value |
|------|-------|
| **Install Command** | Right-click INSTALL.bat → Run as Admin |
| **Install Time** | 10-15 minutes |
| **Default URL** | http://localhost:8080 |
| **Default User** | admin |
| **Default Pass** | Admin123! |
| **Install Path** | C:\inetpub\wwwroot\risk-assessment |
| **Server Start** | start-server.bat or Desktop shortcut |
| **Documentation** | docs\WINDOWS_INSTALLATION_GUIDE.md |

---

## ✨ Features

Your Risk Assessment System includes:

✅ Complete assessment workflow
✅ Location management
✅ User management with roles
✅ Action items tracking
✅ PDF report generation
✅ Email automation (SMTP)
✅ Responsive design (mobile/tablet/desktop)
✅ Admin dashboard
✅ Error logging
✅ Version control

---

## 🎉 Ready to Install?

1. **Ensure** you have Administrator rights
2. **Close** any security software that might interfere
3. **Right-click** INSTALL.bat
4. **Select** "Run as Administrator"
5. **Follow** the prompts
6. **Access** your application at http://localhost:8080

**Installation takes 10-15 minutes. Perfect time for a coffee! ☕**

---

**Need help?** Check `docs\WINDOWS_INSTALLATION_GUIDE.md` for detailed instructions.
