# Risk Assessment System

**Supermarket Delivery Safety Management Platform**

A comprehensive web-based system for conducting, tracking, and managing risk assessments for supermarket delivery operations. Built with PHP, MySQL, and modern JavaScript.

---

## 🎯 Overview

The Risk Assessment System helps organizations:
- Conduct thorough delivery site risk assessments
- Track hazards and control measures
- Manage action items with deadlines
- Generate professional PDF reports
- Monitor compliance across multiple locations
- Maintain version control of assessments
- Automate report distribution via email

---

## ✨ Key Features

### Assessment Management
- **Interactive Forms** - Step-by-step assessment workflow
- **Photo Upload** - Document hazards visually
- **Risk Matrix** - Automatic risk scoring (likelihood × severity)
- **Action Tracking** - Assign owners and due dates
- **Version Control** - Track changes and rollback capability
- **PDF Generation** - Professional assessment reports

### Location Management
- **Multiple Sites** - Manage unlimited locations
- **Contact Details** - Store manager information
- **GPS Integration** - Coordinates and mapping
- **Email Automation** - Automated report distribution
- **Custom Fields** - Flexible data capture

### Reporting & Analytics
- **Action Items Report** - Filter by status, priority, location
- **Dashboard Metrics** - Real-time statistics
- **Export to Excel** - Data analysis capability
- **Historical Tracking** - Trend analysis over time

### Administration
- **User Management** - Role-based access control
- **Permission System** - Granular feature permissions
- **Error Monitoring** - Comprehensive error logging
- **System Customization** - Colors, logos, branding
- **Audit Trail** - Complete activity history

---

## 🚀 Quick Start

### Requirements

**Server:**
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache or Nginx web server

**PHP Extensions:**
- PDO, PDO_MySQL, GD, JSON, Session

### Installation (5 Minutes)

**1. Extract & Navigate**
```bash
tar -xzf risk-system.tar.gz
cd risk-system
```

**2. Create Database**
```bash
mysql -u root -p
CREATE DATABASE risk_assessment;
CREATE USER 'risk_user'@'localhost' IDENTIFIED BY 'your_password';
GRANT ALL ON risk_assessment.* TO 'risk_user'@'localhost';
EXIT;
```

**3. Import Schema**
```bash
mysql -u risk_user -p risk_assessment < includes/complete_schema.sql
```

**4. Configure**
```bash
# Edit includes/config.php
DB_USER = 'risk_user'
DB_PASS = 'your_password'
```

**5. Login**
```
URL: http://yoursite.com/public/login.php
Username: admin
Password: Admin123!
```

✅ **Done! Change the default password immediately.**

---

## 📚 Documentation

Comprehensive guides available in `docs/` directory:

- **[Login Troubleshooting](docs/LOGIN_TROUBLESHOOTING.md)** - Fix login issues
- **[Action Items Report](docs/ACTION_ITEMS_REPORT_GUIDE.md)** - Track pending actions
- **[Automated Emails](docs/AUTOMATED_EMAIL_GUIDE.md)** - Configure report distribution
- **[Error Reporting](docs/ERROR_REPORTING_GUIDE.md)** - Monitor system health
- **[Project Structure](PROJECT_STRUCTURE.md)** - File organization
- **[Development Guidelines](DEVELOPMENT_GUIDELINES.md)** - Coding standards
- **[Deployment Checklist](DEPLOYMENT_CHECKLIST.md)** - Production deployment

---

## 🔧 System Tools

### Validation & Cleanup
```bash
./check-system.sh        # Validate entire system (10 steps)
./cleanup-code.sh        # Remove debug files, organize docs
./diagnose-login.sh      # Fix login issues
```

### Admin Interface
- **Error Logs** - Admin Panel → Error Logs
- **Version Control** - Admin Panel → Version Control
- **User Management** - Admin Panel → User Management
- **Permissions** - Admin Panel → Permissions Management

---

## 📊 Database Migrations

Run migrations to add features:

```bash
# Core system
mysql -u user -p db < includes/complete_schema.sql

# Permissions system
mysql -u user -p db < includes/migration_permissions.sql

# Version control
mysql -u user -p db < includes/migration_version_control.sql

# Audit logging
mysql -u user -p db < includes/migration_audit_log.sql

# Email automation
mysql -u user -p db < includes/migration_location_emails.sql
```

---

## 🎨 Key Workflows

### Conduct Assessment
1. Login → Dashboard → New Assessment
2. Select location and vehicle type
3. Complete risk items (likelihood × severity)
4. Upload photos of hazards
5. Add control measures and actions
6. Submit assessment
7. Generate PDF report

### Track Action Items
1. Reports → Action Items Report
2. Filter by: Location, Status, Priority
3. View overdue/due soon items
4. Export to Excel for tracking
5. Review completion progress

### Manage Locations
1. Locations → Add/Edit Location
2. Enter address and contact details
3. Configure automated email reports
4. Set frequency (immediate/daily/weekly/monthly)
5. Enable automated reports
6. Save configuration

### Monitor System
1. Admin Panel → Error Logs
2. View system errors, debug logs, security events
3. Check statistics (total errors, recent, security)
4. Clear old logs or cleanup
5. Review and address issues

---

## 🔒 Security

- ✅ **Authentication** - Secure session management
- ✅ **Authorization** - Role-based access control
- ✅ **Input Validation** - Sanitized user input
- ✅ **SQL Injection Prevention** - Prepared statements
- ✅ **XSS Protection** - Output escaping
- ✅ **Password Security** - Bcrypt hashing
- ✅ **Audit Logging** - Track all actions
- ✅ **Error Handling** - Safe error messages

**Important:** Change default admin password immediately after installation!

---

## 🛠️ Maintenance

### Daily
- Check error logs: `tail -f logs/system-errors.log`
- Review security events: Admin Panel → Error Logs → Security
- Monitor disk space: `df -h uploads/`

### Weekly
- Run system check: `./check-system.sh`
- Backup database: `mysqldump risk_assessment > backup.sql`
- Clean old logs: Admin Panel → Error Logs → Cleanup Old

### Monthly
- Full backup: `tar -czf backup.tar.gz --exclude='logs/*' .`
- Security audit: Review users, permissions, logs
- Performance check: Database optimization, query analysis

---

## 🐛 Troubleshooting

### Login Not Working
```bash
# Quick fix
./diagnose-login.sh

# Manual reset
php includes/test-password.php
# Choose option 4 to reset admin password
```

### Database Connection Failed
```bash
# Test connection
mysql -u risk_user -p risk_assessment -e "SELECT 1"

# Check config.php settings
# Verify DB credentials are correct
```

### 500 Server Error
```bash
# Check error logs
tail -n 50 logs/system-errors.log

# Check PHP errors
tail -n 50 /var/log/php_errors.log

# Run system check
./check-system.sh
```

### Permission Denied
```bash
# Fix directory permissions
chmod 755 public/ includes/ templates/
chmod 755 uploads/ logs/

# Fix file permissions
chmod 644 public/*.php includes/*.php
chmod 600 includes/config.php
```

---

## 📈 Performance Tips

**Database:**
```sql
-- Add indexes for common queries
CREATE INDEX idx_assessment_date ON assessments(assessment_date);
CREATE INDEX idx_location_id ON assessments(location_id);
```

**PHP Configuration:**
```ini
memory_limit = 256M
upload_max_filesize = 10M
post_max_size = 12M
```

**Caching:**
- Enable OpCache for PHP
- Use CDN for static assets
- Compress uploads folder

---

## 🎯 Project Structure

```
risk-system/
├── includes/          # Backend logic
│   ├── config.php    # Database & settings
│   ├── permissions.php
│   ├── error_handler.php
│   └── *.sql         # Database migrations
├── public/           # Web-accessible
│   ├── login.php
│   ├── dashboard.php
│   ├── assessments.php
│   ├── admin-panel.php
│   └── css/, js/
├── templates/        # Reusable templates
├── uploads/          # User-uploaded files
├── logs/             # Error & debug logs
├── docs/             # Documentation
└── .archive/         # Debug files (safe to delete)
```

---

## 📝 Version History

**v1.0.0** (2026-01-08)
- ✅ Complete assessment system
- ✅ Location & user management
- ✅ Action items tracking
- ✅ PDF report generation
- ✅ Permission system
- ✅ Version control
- ✅ Error logging
- ✅ Email configuration (foundation)

---

## ⚡ Quick Reference Card

**Default Credentials:**
```
Username: admin
Password: Admin123!
⚠️ CHANGE IMMEDIATELY AFTER LOGIN
```

**Important URLs:**
```
Login:  /public/login.php
Dashboard: /public/dashboard.php
Admin: /public/admin-panel.php
Reports: /public/reports.php
```

**System Commands:**
```bash
./check-system.sh      # Validate system
./cleanup-code.sh      # Clean & organize
./diagnose-login.sh    # Fix login
```

**Log Files:**
```
logs/system-errors.log  # PHP errors
logs/security.log       # Security events
logs/debug.log          # Debug info
```

---

## 🤝 Development

### Code Standards
- Follow `DEVELOPMENT_GUIDELINES.md`
- Test with `./check-system.sh`
- Document all changes
- Use prepared statements
- Sanitize all output

### Before Committing
```bash
# Run validation
./check-system.sh

# Test functionality
# - Login/logout
# - Create assessment
# - Generate report
# - Check permissions

# Clean debug files
./cleanup-code.sh
```

---

## 📞 Support Resources

**Self-Help:**
1. Check `docs/` directory
2. Review error logs
3. Run `./check-system.sh`
4. Read troubleshooting section

**Admin Tools:**
- Error Logs viewer (Admin Panel)
- Version Control (Admin Panel)
- System validation script

**Common Issues:**
- Login: `./diagnose-login.sh`
- Permissions: Check `chmod` settings
- Database: Verify connection in config.php

---

## 🎓 Training Resources

### For New Users
1. Review dashboard tour
2. Practice creating assessment
3. Generate sample report
4. Explore action items
5. Learn filtering options

### For Administrators
1. Read `DEVELOPMENT_GUIDELINES.md`
2. Review `PROJECT_STRUCTURE.md`
3. Study permission system
4. Test backup/restore
5. Practice troubleshooting

---

## 📄 License

This software is proprietary. All rights reserved.

---

## 🚀 Next Steps After Installation

1. ✅ **Login** with admin/Admin123!
2. ✅ **Change password** (Users → Edit Admin)
3. ✅ **Add locations** (Locations → Add New)
4. ✅ **Create users** (Users → Add User)
5. ✅ **Configure permissions** (Admin Panel → Permissions)
6. ✅ **Setup email automation** (Locations → Edit → Emails)
7. ✅ **Create first assessment** (Dashboard → New Assessment)
8. ✅ **Review reports** (Reports → Action Items)
9. ✅ **Monitor system** (Admin Panel → Error Logs)
10. ✅ **Schedule backups** (Set up cron jobs)

---

**🎉 System ready! Start managing your delivery safety today!**

For detailed information, see the comprehensive guides in the `docs/` directory.
