# QUICK START GUIDE

## 🚀 Get Started in 5 Minutes

---

## ✅ Prerequisites

- Web server (Apache/Nginx/IIS)
- PHP 7.4+
- MySQL 5.7+
- 500MB disk space

---

## 📦 Installation

### **1. Extract & Setup Database**

```bash
# Extract files
tar -xzf risk-system-FIXED.tar.gz

# Create and import database
mysql -u root -p -e "CREATE DATABASE scubatricky_risk"
mysql -u root -p scubatricky_risk < schema.sql
```

### **2. Configure**

Edit `includes/config.php`:
```php
define('DB_NAME', 'scubatricky_risk');
define('DB_USER', 'root');
define('DB_PASS', 'your_password');
```

### **3. Set Permissions**

```bash
chmod 755 uploads logs public/uploads
```

### **4. Start**

```bash
cd public && php -S localhost:8080
```

---

## 🔐 Login

```
URL: http://localhost:8080
Username: admin
Password: Admin123!
```

⚠️ **Change password immediately!**

---

## 🎯 Quick Setup

1. ✅ Change admin password
2. ✅ Add first location
3. ✅ Create test assessment
4. ✅ Generate PDF report

**Done!** 🎉

---

## 📚 Documentation

- `DATABASE_SCHEMA.md` - Database info
- `README.md` - Full guide
- `docs/` - Feature guides

---

## 🚨 Troubleshooting

**Can't login?**
```bash
# Reset password to Admin123!
mysql -u root -p scubatricky_risk -e "UPDATE users SET password='$2y$10\$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi' WHERE username='admin'"
```

**Database error?**
- Check `includes/config.php`
- Verify database exists
- Check credentials

**Permission error?**
```bash
chmod -R 755 uploads logs
```

---

## ✨ You're Ready!

Start creating risk assessments now! 🚀
