# Quick Start Guide - Risk Assessment System

## 🚀 5-Minute Setup

### Prerequisites
- LAMP/LEMP server (Linux, Apache/Nginx, MySQL, PHP)
- Python 3 installed
- Command line access

### Step 1: Database Setup (2 minutes)
```bash
# Login to MySQL
mysql -u scubatricky_risk -p

# Run these commands:
CREATE DATABASE scubatricky_risk CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
CREATE USER 'riskassess_user'@'localhost' IDENTIFIED BY 'ChangeThisPassword123!';
GRANT ALL PRIVILEGES ON scubatricky_risk.* TO 'riskassess_user'@'localhost';
FLUSH PRIVILEGES;
exit;

# Import the database schema
mysql -u riskassess_user -p scubatricky_risk < includes/schema.sql
```

### Step 2: Configure Application (1 minute)
Edit `includes/config.php`:
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'riskassess_user');
define('DB_PASS', 'ChangeThisPassword123!');  // Use your password
define('DB_NAME', 'scubatricky_risk');
define('SITE_URL', 'http://localhost/risk-assessment-app');  // Your URL
```

### Step 3: Set Permissions (1 minute)
```bash
# Make reports directory writable
chmod 755 reports/
chown www-data:www-data reports/

# Make Python script executable
chmod +x public/api/generate_pdf.py

# Install Python dependencies
pip3 install reportlab --break-system-packages
```

### Step 4: Access Application (1 minute)
1. Open browser: `http://localhost/risk-assessment-app` (or your server URL)
2. Login with default credentials:
   - Username: `admin`
   - Password: `Admin123!`
3. Change the password immediately!

## ✅ You're Done!

### What's Next?

1. **Add Locations**: Go to Locations → Add delivery point addresses
2. **Create Assessment**: Click "New Assessment" → Select location → Rate risks
3. **Generate Report**: View assessment → Click "Generate PDF"
4. **Add Users**: Admin panel → Users → Add team members

### Quick Tips

- **Offline Mode**: Works offline! Data syncs when back online
- **Auto-save**: Drafts save automatically every few seconds
- **Mobile App**: Install as PWA from browser menu (Chrome/Edge)
- **PDF Customization**: Edit `public/api/generate_pdf.py` for branding

### Common Issues

**"Database connection failed"**
- Check credentials in `includes/config.php`
- Verify MySQL is running: `systemctl status mysql`

**"PDF generation failed"**
- Install ReportLab: `pip3 install reportlab --break-system-packages`
- Check Python path in `generate-pdf.php`
- Verify reports/ directory permissions

**"Page not loading"**
- Check Apache/Nginx is running
- Verify document root points to `public/` directory
- Check file permissions: `chmod -R 755 .`

### Getting Help

1. Check `README.md` for detailed documentation
2. Review server error logs: `/var/log/apache2/error.log`
3. Check browser console for JavaScript errors
4. Ensure all requirements are met (PHP 7.4+, MySQL 5.7+, Python 3.7+)

---

**Ready to create your first risk assessment? Login and click "New Assessment"!** 🎯
