# Risk Assessment System - Project Structure

## Directory Organization

```
risk-system/
├── includes/              # Backend PHP includes
│   ├── config.php        # Database & app configuration
│   ├── permissions.php   # Permission system
│   ├── error_handler.php # Error reporting & logging
│   ├── version_control.php # Version control functions
│   ├── complete_schema.sql # Complete database schema
│   └── migration_*.sql   # Database migrations
│
├── public/               # Web-accessible files
│   ├── login.php         # Login page
│   ├── dashboard.php     # Main dashboard
│   ├── assessments.php   # Assessment management
│   ├── locations.php     # Location management
│   ├── users.php         # User management
│   ├── admin-panel.php   # Admin control panel
│   ├── reports.php       # Reports dashboard
│   ├── action-items-report.php # Action items report
│   ├── error-logs.php    # Error log viewer
│   ├── version-control.php # Version control UI
│   ├── css/              # Stylesheets
│   ├── js/               # JavaScript files
│   └── api/              # API endpoints
│
├── templates/            # PHP templates
│   ├── header.php        # Common header
│   └── footer.php        # Common footer
│
├── uploads/              # User uploads (photos, documents)
├── logs/                 # System logs
│   ├── system-errors.log # Error log
│   ├── debug.log         # Debug log
│   └── security.log      # Security events
│
├── docs/                 # Documentation
│   ├── LOGIN_TROUBLESHOOTING.md
│   ├── ACTION_ITEMS_REPORT_GUIDE.md
│   ├── ERROR_REPORTING_GUIDE.md
│   └── AUTOMATED_EMAIL_GUIDE.md
│
├── .archive/             # Archived debug/backup files
│   ├── debug-files/
│   └── backup-files/
│
├── check-system.sh       # System validation script
├── diagnose-login.sh     # Login diagnostic tool
├── cleanup-code.sh       # This cleanup script
└── README.md             # Main documentation
```

## File Naming Conventions

### PHP Files
- **Pages**: `page-name.php` (e.g., `login.php`, `dashboard.php`)
- **Includes**: `functionality.php` (e.g., `config.php`, `permissions.php`)
- **API**: `api/endpoint-name.php` (e.g., `api/save-assessment.php`)

### SQL Files
- **Schema**: `complete_schema.sql`
- **Migrations**: `migration_feature_name.sql`

### JavaScript Files
- **Components**: `component-name.js` (e.g., `vue-components.js`)
- **Utilities**: `utility-name.js` (e.g., `app.js`)

### CSS Files
- **Main**: `style.css`
- **Component**: `component.css`

## Code Organization

### Backend (PHP)
```
includes/
  ├── config.php           # Database connection, constants
  ├── permissions.php      # Authorization functions
  ├── error_handler.php    # Error logging & display
  └── version_control.php  # File versioning
```

### Frontend (Public)
```
public/
  ├── User Management      # users.php, login.php
  ├── Assessments          # assessments.php, new-assessment.php
  ├── Locations            # locations.php, edit-location.php
  ├── Reports              # reports.php, action-items-report.php
  └── Admin                # admin-panel.php, error-logs.php
```

### Templates
```
templates/
  ├── header.php           # <head>, navigation, opening <body>
  └── footer.php           # Closing tags, scripts
```

## Key Features by File

### Core System
- `config.php` - Database, sessions, constants
- `permissions.php` - Role-based access control
- `error_handler.php` - Error logging & handling

### User Interface
- `dashboard.php` - Main landing page
- `admin-panel.php` - System administration
- `reports.php` - Reporting dashboard

### Assessment System
- `assessments.php` - List/manage assessments
- `new-assessment.php` - Create assessment
- `action-items-report.php` - Action tracking

### Location Management
- `locations.php` - List locations
- `edit-location.php` - Edit/create location
- `view-location.php` - Location details

### Administration
- `users.php` - User management
- `error-logs.php` - Error monitoring
- `version-control.php` - File versioning

## Development Workflow

1. **Adding Features**: Create in `public/`, use includes from `includes/`
2. **Database Changes**: Create migration in `includes/migration_*.sql`
3. **Styling**: Update `public/css/style.css`
4. **Scripts**: Add to `public/js/`
5. **Documentation**: Update relevant guide in `docs/`

## Maintenance

- **Logs**: Check `logs/` directory regularly
- **Uploads**: Backup `uploads/` directory
- **Database**: Regular backups, run migrations
- **Code**: Run `check-system.sh` before deployment

## Security

- `includes/config.php` - Not in version control
- `uploads/` - User files, proper permissions
- `logs/` - Writable by web server
- `.htaccess` - Protect sensitive directories
