# PASSWORD RESET QUICK REFERENCE

## Problem Fixed
✅ All `password_hash` column references changed to `password`
✅ Database schema uses `password` as column name
✅ PHP function `password_hash()` still works correctly

## Files Fixed (9 occurrences across 4 files)
1. `/includes/reset-password.php` - 3 fixes
2. `/public/reset-admin.php` - 2 fixes  
3. `/public/login.php` - 2 fixes
4. `/public/users.php` - 2 fixes

## Reset Admin Password

### Method 1: Web Interface (Recommended)
1. Navigate to: `http://yoursite.com/public/reset-admin.php`
2. Default password shown: `Admin123!`
3. Click "Reset Admin Password"
4. Login with credentials shown
5. **DELETE reset-admin.php immediately after use!**

### Method 2: Command Line
```bash
cd /path/to/risk-system
php includes/reset-password.php

# Choose option:
# 1 - Reset to Admin123! (quick)
# 2 - Custom password
# 3 - Generate hash only
```

### Method 3: Direct SQL
```sql
-- Generate hash first
php -r "echo password_hash('YourNewPassword', PASSWORD_DEFAULT);"

-- Then run SQL
UPDATE users SET password = '$2y$10$...' WHERE username = 'admin';
```

## Login Credentials
```
Username: admin
Password: Admin123!
```

## After First Login
1. Go to Admin Panel → Users
2. Edit admin user
3. Set a strong new password
4. Save changes

## Security Notes
⚠️ Delete `public/reset-admin.php` after use
⚠️ Change default password immediately
⚠️ Use strong passwords (12+ characters, mixed case, numbers, symbols)

## Troubleshooting

### Error: Column 'password_hash' not found
✅ FIXED - Download the latest archive

### Error: Cannot login
- Check username/password
- Verify user is active
- Check browser console for errors
- Clear browser cache/cookies

### Error: Permission denied
- Check file permissions
- Verify database connection
- Check config.php settings

## Database Schema
```sql
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,  -- ← Column name is "password"
    full_name VARCHAR(100) NOT NULL,
    email VARCHAR(100) NOT NULL UNIQUE,
    role ENUM('admin', 'assessor', 'viewer') DEFAULT 'assessor',
    is_active BOOLEAN DEFAULT TRUE,
    ...
);
```

## Verification Commands
```bash
# Check for remaining password_hash column references (should be empty)
grep -r "password_hash" --include="*.php" | grep -E "(SET|INSERT|SELECT|UPDATE)" | grep -v "password_hash("

# Verify password_hash() function is still present (should show results)
grep -r "password_hash(" --include="*.php"
```

## Support
All password operations now work correctly:
✅ Login
✅ Password reset
✅ Create new user
✅ Update user password
✅ Admin password recovery

No more "Column not found" errors!
