@echo off
REM ============================================================================
REM Risk Assessment System - Installation Launcher
REM This batch file launches the PowerShell installer with admin privileges
REM ============================================================================

title Risk Assessment System - Installer

echo.
echo ============================================================================
echo   Risk Assessment System - Windows 11 Installer
echo ============================================================================
echo.

REM Check if running as administrator
net session >nul 2>&1
if %errorLevel% neq 0 (
    echo ERROR: This installer requires administrator privileges.
    echo.
    echo Please right-click this file and select "Run as Administrator"
    echo.
    pause
    exit /b 1
)

echo Checking PowerShell...
powershell -Command "Write-Host 'PowerShell is available'" >nul 2>&1
if %errorLevel% neq 0 (
    echo ERROR: PowerShell is not available or not working correctly.
    echo Please ensure PowerShell 5.1 or higher is installed.
    echo.
    pause
    exit /b 1
)

echo.
echo Starting installation...
echo.

REM Run PowerShell installer
powershell.exe -ExecutionPolicy Bypass -File "%~dp0Install-RiskAssessment.ps1"

if %errorLevel% equ 0 (
    echo.
    echo ============================================================================
    echo Installation completed successfully!
    echo ============================================================================
    echo.
) else (
    echo.
    echo ============================================================================
    echo Installation failed. Please check the error messages above.
    echo ============================================================================
    echo.
)

pause
