# Deployment Checklist

## Pre-Deployment

### Code Quality
- [ ] Run `./check-system.sh` - All checks pass
- [ ] Remove debug files (`./cleanup-code.sh`)
- [ ] Review error logs
- [ ] Test all critical functions
- [ ] Check PHP syntax errors

### Database
- [ ] Backup current database
- [ ] Test migrations on staging
- [ ] Verify schema matches complete_schema.sql
- [ ] Check indexes are in place
- [ ] Confirm foreign keys are correct

### Configuration
- [ ] Update `includes/config.php` with production values
- [ ] Set database credentials
- [ ] Configure SITE_URL
- [ ] Set session security (cookie_secure = 1 for HTTPS)
- [ ] Review upload path settings

### Security
- [ ] Change default admin password
- [ ] Remove test accounts
- [ ] Set proper file permissions (755 directories, 644 files)
- [ ] Restrict config.php (600 permissions)
- [ ] Enable HTTPS
- [ ] Configure firewall rules

### Files & Directories
- [ ] Create `uploads/` directory (writable)
- [ ] Create `logs/` directory (writable)
- [ ] Remove `.archive/` directory
- [ ] Verify `.gitignore` is correct
- [ ] Check no sensitive data in repository

## Deployment Steps

1. **Backup Production**
   ```bash
   mysqldump -u user -p database > backup_$(date +%Y%m%d).sql
   tar -czf files_backup_$(date +%Y%m%d).tar.gz public/ includes/
   ```

2. **Upload Files**
   ```bash
   rsync -avz --exclude='.git' --exclude='logs/*' --exclude='uploads/*' \
         ./ user@server:/path/to/app/
   ```

3. **Set Permissions**
   ```bash
   chmod 755 public/ includes/ templates/
   chmod 644 public/*.php includes/*.php
   chmod 600 includes/config.php
   chmod 755 uploads/ logs/
   ```

4. **Run Migrations**
   ```bash
   mysql -u user -p database < includes/complete_schema.sql
   mysql -u user -p database < includes/migration_*.sql
   ```

5. **Test Application**
   - [ ] Login works
   - [ ] Dashboard loads
   - [ ] Create test assessment
   - [ ] Upload photo
   - [ ] Generate report
   - [ ] Check error logs

## Post-Deployment

### Verification
- [ ] All pages load without errors
- [ ] Database connections work
- [ ] File uploads function
- [ ] Email settings configured
- [ ] Permissions work correctly
- [ ] Reports generate properly

### Monitoring
- [ ] Set up error log monitoring
- [ ] Configure backup schedule
- [ ] Monitor disk space
- [ ] Check performance
- [ ] Review security logs

### Documentation
- [ ] Update deployment date in README
- [ ] Document any custom configurations
- [ ] Share credentials securely
- [ ] Update maintenance schedule

## Rollback Plan

If deployment fails:

1. **Restore Database**
   ```bash
   mysql -u user -p database < backup_YYYYMMDD.sql
   ```

2. **Restore Files**
   ```bash
   tar -xzf files_backup_YYYYMMDD.tar.gz -C /path/to/app/
   ```

3. **Clear Cache**
   ```bash
   rm -rf logs/*.log
   ```

4. **Test System**
   - Verify login
   - Check database connection
   - Test core functions

## Production Maintenance

### Daily
- Check error logs
- Monitor disk space
- Review failed logins

### Weekly
- Backup database
- Review user activity
- Check system performance
- Update action items

### Monthly
- Full system backup
- Review permissions
- Update documentation
- Security audit
- Performance optimization

## Support Contacts

- **Technical Support**: support@company.com
- **Database Admin**: dba@company.com
- **Security Team**: security@company.com
