# API Keys Setup - Quick Guide

## 🗺️ Google Maps API (Required for Map Features)

### Quick Setup (5 minutes)

1. **Go to Google Cloud Console**
   - Visit: https://console.cloud.google.com/
   - Sign in with Google account

2. **Create Project**
   - Click "Select a project" → "New Project"
   - Name: "Risk Assessment System"
   - Click "Create"

3. **Enable APIs** (Enable all three)
   - Go to "APIs & Services" → "Library"
   - Search and enable:
     * ✅ Maps JavaScript API
     * ✅ Geocoding API  
     * ✅ Places API

4. **Create API Key**
   - Go to "Credentials"
   - Click "Create Credentials" → "API Key"
   - Copy the key (starts with `AIza...`)

5. **Restrict API Key** (Security - Important!)
   ```
   Application restrictions:
   - HTTP referrers (web sites)
   - Add: https://your-domain.com/*
   
   API restrictions:
   - Restrict key
   - Select only: Maps JavaScript API, Geocoding API, Places API
   ```

6. **Add to Application**
   
   Edit these 3 files and replace `YOUR_GOOGLE_MAPS_API_KEY`:
   - `public/add-location.php` (line ~15)
   - `public/edit-location.php` (line ~15)
   - `public/view-location.php` (line ~285)
   
   Find:
   ```javascript
   <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_GOOGLE_MAPS_API_KEY&libraries=places"></script>
   ```
   
   Replace with:
   ```javascript
   <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBxxxxxx&libraries=places"></script>
   ```

### Cost
- **FREE**: 28,000 map loads per month
- **FREE**: $200 monthly credit
- **Typical Usage**: ~500-1000 requests/month
- **You Won't Pay**: Unless you have 1000+ locations or heavy usage

---

## 🌍 What3Words API (Optional - Recommended)

### Quick Setup (3 minutes)

1. **Register**
   - Visit: https://developer.what3words.com/
   - Click "Get started for free"
   - Complete registration

2. **Get API Key**
   - After login, go to "API Keys"
   - Copy your API key

3. **Add to Application**
   
   Edit `public/add-location.php` (around line 400)
   
   Find function `fetchWhat3Words` and uncomment/update:
   ```javascript
   async function fetchWhat3Words(lat, lng) {
       try {
           const response = await fetch(
               `https://api.what3words.com/v3/convert-to-3wa?coordinates=${lat},${lng}&key=YOUR_W3W_API_KEY`
           );
           const data = await response.json();
           document.getElementById('what3words').value = data.words;
       } catch (error) {
           console.error('What3Words error:', error);
       }
   }
   ```
   
   Replace `YOUR_W3W_API_KEY` with your actual key.

### Cost
- **FREE**: 25,000 requests per month
- **Typical Usage**: 50-200 requests/month
- **You Won't Pay**: More than enough for most use cases

---

## ⚙️ Alternative: No API Keys

The system works without API keys, but with limitations:

### Without Google Maps:
- ❌ No interactive map display
- ❌ No auto-geocoding from address
- ✅ Can still enter GPS coordinates manually
- ✅ Can still link to Google Maps (opens externally)

### Without What3Words:
- ❌ No automatic What3Words lookup
- ✅ Can still enter What3Words manually
- ✅ Can lookup on what3words.com and copy/paste

### Manual Workflow (No APIs):
1. Enter address
2. Go to Google Maps website
3. Find location, right-click → "What's here?"
4. Copy coordinates
5. Paste into application
6. Go to what3words.com
7. Search coordinates
8. Copy three words
9. Paste into application

**Time**: ~2 minutes per location vs. 5 seconds with APIs

---

## 🔧 Testing Your Setup

### Test Google Maps:
1. Go to: `your-domain.com/add-location.php`
2. You should see a map load
3. Enter an address
4. Click "Find on Map"
5. Map should center and marker should place

**If map doesn't load**:
- Open browser console (F12)
- Look for error messages
- Common issues:
  - Wrong API key
  - APIs not enabled
  - Referrer restrictions wrong
  - Billing not enabled

### Test What3Words:
1. Add location with GPS coordinates
2. What3Words field should auto-fill
3. Should show three words like "filled.count.soap"

**If not working**:
- Check console for errors
- Verify API key is correct
- Check monthly quota

---

## 📊 Usage Monitoring

### Google Cloud Console:
- Go to "APIs & Services" → "Dashboard"
- View API usage graphs
- Check quota limits
- Monitor costs (should be $0)

### What3Words Dashboard:
- Login to developer.what3words.com
- View "Usage" tab
- See request counts
- Monitor quota

---

## 🚨 Troubleshooting

### "Google Maps JavaScript API error: ApiNotActivatedMapError"
→ Enable Maps JavaScript API in Google Cloud Console

### "Google Maps JavaScript API error: RefererNotAllowedMapError"  
→ Add your domain to HTTP referrer restrictions

### "This page can't load Google Maps correctly"
→ Check API key is correct and billing is enabled

### Map shows but "Find on Map" doesn't work
→ Enable Geocoding API in Google Cloud Console

### What3Words returns error
→ Check API key and verify you haven't exceeded quota

---

## 💰 Staying Within Free Limits

### Google Maps:
- ~28,000 map loads per month free
- Each page view with map = 1 load
- Each "Find on Map" click = 1 geocode request
- **Typical small business**: 500-1000 per month ✅ Free
- **Typical enterprise**: 5000-10000 per month ✅ Free

### What3Words:
- 25,000 conversions per month free
- Each GPS → What3Words lookup = 1 conversion
- **Any realistic usage**: ✅ Free

### Tips to Minimize Usage:
- Cache location data (already implemented)
- Only load maps when needed
- Use stored coordinates instead of re-geocoding

---

## 📞 Support Links

- **Google Maps**: https://developers.google.com/maps/documentation
- **What3Words**: https://developer.what3words.com/tutorial
- **Stack Overflow**: Tag questions with `google-maps-api-3` or `what3words`

---

## ✅ Final Checklist

- [ ] Google Cloud project created
- [ ] Three APIs enabled (Maps, Geocoding, Places)
- [ ] API key created and copied
- [ ] API key restrictions configured
- [ ] API key added to 3 PHP files
- [ ] Test map loads successfully
- [ ] Test "Find on Map" works
- [ ] What3Words account created (optional)
- [ ] What3Words API key added (optional)
- [ ] Test What3Words auto-fill (optional)

**Setup Time**: 5-10 minutes for basic Google Maps, +3 minutes for What3Words

**Result**: Fully functional location management with interactive maps! 🎉
