# ACTION ITEMS REPORT - QUICK REFERENCE

## ✅ Already Included in System!

The Action Items Report is **already built and accessible** in your Risk Assessment System.

---

## 📍 How to Access

### Method 1: Via Reports Page
```
1. Login to the system
2. Navigate to: Reports & Analytics
3. Look for "Action Items Report" card at top
4. Click "View Action Items Report →"
```

### Method 2: Direct URL
```
http://yoursite.com/public/action-items-report.php
```

---

## 🎯 Features

### 1. **Multiple Filter Options**
- **By Location** - View actions for specific store/location
- **By Status:**
  - ⚠️ Overdue (past due date)
  - 🔔 Due Soon (within 7 days)
  - ✅ On Track (more than 7 days away)
  - ❓ No Due Date (not yet scheduled)
- **By Priority:**
  - 🔴 Critical (Risk Score 20-25)
  - 🟠 High (Risk Score 15-19)
  - 🟡 Medium (Risk Score 10-14)
  - 🟢 Low (Risk Score 1-9)

### 2. **Statistics Dashboard**
Shows at top of report:
- 📋 Total Actions
- ⚠️ Overdue Actions (highlighted red)
- 🔔 Due Soon Actions (highlighted orange)
- ✅ On Track Actions
- ❓ No Due Date Actions

### 3. **Detailed Action Cards**
Each action item shows:
- Risk category and specific hazard
- Full action description
- Action owner (if assigned)
- Target due date
- Days until due / overdue
- Priority badge (based on risk score)
- Risk level from assessment
- Link to full assessment
- Assessment number and date
- Assessor name

### 4. **Export Options**
- 📊 **Export to Excel** - Download as CSV
- 🖨️ **Print Report** - Print-optimized layout

---

## 🔍 Example Use Cases

### **Weekly Management Review**
```
1. Go to Action Items Report
2. Filter: Status = "Overdue"
3. Review all overdue actions
4. Assign or follow up with owners
5. Export for tracking
```

### **Store Manager Check-In**
```
1. Go to Action Items Report
2. Filter: Location = "Store Name"
3. See all pending actions for that store
4. Plan work schedule based on priorities
5. Check due dates
```

### **Priority Actions**
```
1. Go to Action Items Report
2. Filter: Priority = "Critical"
3. See highest risk items first
4. Allocate resources
5. Track completion
```

### **Monthly Report**
```
1. Go to Action Items Report
2. Select: All Locations
3. Export to Excel
4. Send to management
5. Track trends over time
```

---

## 📊 Report Layout

```
📋 Action Items Report
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

Filters: [Location ▼] [Status ▼] [Priority ▼] [Clear]

Statistics:
┌──────────┬──────────┬──────────┬──────────┐
│ 📋 Total │ ⚠️ Overdue│ 🔔 Due Soon│ ✅ On Track│
│   24     │    3     │     5     │    14    │
└──────────┴──────────┴──────────┴──────────┘

📍 Store Name (5 actions)
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

🚪 Narrow entrance/exit        [HIGH RISK]
Category: Access & Egress
Assessment: RA-2026-ABC123
Date: 05 Jan 2026
Assessor: John Smith

Action Required:
Install wider gates and improve signage for better 
vehicle access during peak hours.

🔴 Critical (20) | 👤 Owner: Site Manager
📅 Due: 10 Jan 2026 (3 days)
⚠️ Overdue

[View Assessment →]

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

[More actions...]
```

---

## 🎨 Visual Indicators

### Status Colors
- 🔴 **Red border** - Overdue actions
- 🟠 **Orange border** - Due soon (within 7 days)
- ⚫ **No border** - On track or no date

### Priority Badges
- 🔴 **Critical** - Dark red background (20-25 score)
- 🟠 **High** - Orange background (15-19 score)
- 🟡 **Medium** - Yellow background (10-14 score)
- 🟢 **Low** - Green background (1-9 score)

### Status Badges
- ⚠️ **Overdue** - Red badge
- 🔔 **Due Soon** - Orange badge
- ✅ **On Track** - Green badge
- ❓ **No Date** - Gray badge

---

## 📋 Data Shown

For each action item:
```sql
- Risk item name & category
- Full action description  
- Action owner (if assigned)
- Target due date
- Days until due / days overdue
- Risk score (determines priority)
- Overall risk level of assessment
- Assessment number
- Assessment date
- Assessor name
- Location information
- Direct link to full assessment
```

---

## 🔧 How It Works

### Status Calculation
```javascript
if (target_date < today) 
    → Status: "Overdue" ⚠️

else if (target_date <= today + 7 days) 
    → Status: "Due Soon" 🔔

else if (target_date > today + 7 days) 
    → Status: "On Track" ✅

else 
    → Status: "No Due Date" ❓
```

### Priority Calculation
```javascript
if (risk_score >= 20) → Priority: "Critical" 🔴
else if (risk_score >= 15) → Priority: "High" 🟠
else if (risk_score >= 10) → Priority: "Medium" 🟡
else → Priority: "Low" 🟢
```

### Smart Sorting
Actions are sorted by:
1. Overdue first (most urgent)
2. Due soon second
3. On track third
4. No date last
5. Within each: highest risk score first

---

## 💡 Tips

**Filter Combinations:**
- Location + Overdue = See urgent items per store
- Priority Critical + All Locations = System-wide urgent actions
- Status Due Soon = Plan upcoming work
- Location + No Date = Items needing scheduling

**Export Uses:**
- Weekly management reports
- Store performance tracking
- Resource planning
- Compliance documentation
- Trend analysis

**Best Practices:**
- Review overdue items daily
- Check due soon weekly
- Export monthly for records
- Filter by location for store managers
- Filter by priority for resource allocation

---

## 🚀 Quick Start

**For Store Managers:**
```
1. Navigate to: Reports → Action Items Report
2. Select your location from dropdown
3. Review all pending actions
4. Note due dates and priorities
5. Plan your work schedule
```

**For Safety Officers:**
```
1. Navigate to: Reports → Action Items Report
2. Filter by: Priority = Critical
3. Review high-risk items
4. Follow up on overdue actions
5. Export for compliance records
```

**For Management:**
```
1. Navigate to: Reports → Action Items Report
2. View all locations
3. Check overdue count in statistics
4. Export to Excel
5. Distribute to relevant managers
```

---

## 📊 Export Format

**Excel/CSV Export includes:**
```
Location, Risk Category, Risk Item, Action Required, 
Owner, Target Date, Status, Priority, Assessment #
```

**Perfect for:**
- Spreadsheet tracking
- Import to project management tools
- Management reporting
- Historical records
- Trend analysis

---

## ✅ Current Status

The Action Items Report is:
- ✅ **Fully built and tested**
- ✅ **Accessible from Reports page**
- ✅ **Includes all filtering options**
- ✅ **Shows statistics dashboard**
- ✅ **Provides Excel export**
- ✅ **Print-optimized**
- ✅ **Mobile responsive**
- ✅ **Ready to use immediately**

---

## 🎯 To Start Using

**Right Now:**
1. Login to your Risk Assessment System
2. Click "Reports & Analytics" in navigation
3. Look for the featured "Action Items Report" card
4. Click "View Action Items Report →"
5. Start filtering and tracking actions!

**No setup required - it's ready to use!** 🎉

---

## 📞 Report Features Summary

| Feature | Status |
|---------|--------|
| Filter by Location | ✅ |
| Filter by Status | ✅ |
| Filter by Priority | ✅ |
| Statistics Dashboard | ✅ |
| Detailed Action Cards | ✅ |
| Excel Export | ✅ |
| Print Layout | ✅ |
| Direct Assessment Links | ✅ |
| Visual Priority Indicators | ✅ |
| Overdue Highlighting | ✅ |
| Due Date Tracking | ✅ |
| Owner Assignment Display | ✅ |
| Risk Score Display | ✅ |
| Mobile Responsive | ✅ |

---

**Everything is already built and ready to use!** 📋✨
