#!/bin/bash

echo "=========================================="
echo "Photo Upload Verification Script"
echo "=========================================="
echo ""

ERRORS=0

# 1. Check database column
echo "1. Checking database column..."
mysql -u root -p risk_assessment_db -e "SHOW COLUMNS FROM assessment_risks LIKE 'photos';" 2>/dev/null | grep -q photos
if [ $? -eq 0 ]; then
    echo "   ✓ Photos column exists in assessment_risks table"
else
    echo "   ✗ Photos column MISSING - Run: mysql -u root -p risk_assessment_db < database/photo_upload_fix.sql"
    ERRORS=$((ERRORS+1))
fi

# 2. Check upload directory
echo ""
echo "2. Checking upload directory..."
if [ -d "public/uploads/assessments" ]; then
    echo "   ✓ Upload directory exists: public/uploads/assessments/"
    PERMS=$(ls -ld public/uploads/assessments | awk '{print $1}')
    echo "   Permissions: $PERMS"
    
    # Check if writable
    if [ -w "public/uploads/assessments" ]; then
        echo "   ✓ Directory is writable"
    else
        echo "   ✗ Directory is NOT writable - Run: chmod 755 public/uploads/assessments"
        ERRORS=$((ERRORS+1))
    fi
else
    echo "   ✗ Upload directory MISSING - Run: mkdir -p public/uploads/assessments && chmod 755 public/uploads/assessments"
    ERRORS=$((ERRORS+1))
fi

# 3. Check PhotoUpload.php path
echo ""
echo "3. Checking PhotoUpload.php upload path..."
if grep -q "public/uploads/assessments" includes/PhotoUpload.php; then
    echo "   ✓ Upload path is correct (/public/uploads/assessments/)"
else
    echo "   ✗ Upload path may be incorrect"
    ERRORS=$((ERRORS+1))
fi

# 4. Check GD library
echo ""
echo "4. Checking PHP GD library (required for image processing)..."
php -m | grep -q -i gd
if [ $? -eq 0 ]; then
    echo "   ✓ GD library is installed"
else
    echo "   ✗ GD library NOT installed - Install with: sudo apt-get install php-gd"
    ERRORS=$((ERRORS+1))
fi

# 5. Check API endpoints
echo ""
echo "5. Checking API endpoints..."
if [ -f "public/api/upload-photo.php" ]; then
    echo "   ✓ upload-photo.php exists"
else
    echo "   ✗ upload-photo.php MISSING"
    ERRORS=$((ERRORS+1))
fi

if [ -f "public/api/delete-photo.php" ]; then
    echo "   ✓ delete-photo.php exists"
else
    echo "   ✗ delete-photo.php MISSING"
    ERRORS=$((ERRORS+1))
fi

# 6. Check PhotoUpload class
echo ""
echo "6. Checking PhotoUpload class..."
if [ -f "includes/PhotoUpload.php" ]; then
    echo "   ✓ PhotoUpload.php exists"
else
    echo "   ✗ PhotoUpload.php MISSING"
    ERRORS=$((ERRORS+1))
fi

# 7. Check file permissions
echo ""
echo "7. Checking file permissions..."
if [ -f "public/api/upload-photo.php" ]; then
    PERMS=$(stat -c "%a" public/api/upload-photo.php 2>/dev/null || stat -f "%OLp" public/api/upload-photo.php 2>/dev/null)
    echo "   upload-photo.php: $PERMS"
fi

echo ""
echo "=========================================="
if [ $ERRORS -eq 0 ]; then
    echo "✅ ALL CHECKS PASSED!"
    echo "Photo upload functionality should work correctly."
else
    echo "❌ FOUND $ERRORS ISSUE(S)"
    echo "Please fix the issues listed above."
fi
echo "=========================================="
