<?php
require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Auth.php';
require_once '../includes/functions.php';
require_once '../includes/VersionControl.php';

$auth = new Auth();
$auth->requireLogin();

$versionControl = new VersionControl();
$pageTitle = 'Compare Versions';

$versionId1 = $_GET['id1'] ?? 0;
$versionId2 = $_GET['id2'] ?? 0;

if (!$versionId1 || !$versionId2) {
    setFlashMessage('Invalid version IDs', 'danger');
    header('Location: assessments.php');
    exit;
}

try {
    $comparison = $versionControl->compareVersions($versionId1, $versionId2);
} catch (Exception $e) {
    setFlashMessage('Error: ' . $e->getMessage(), 'danger');
    header('Location: assessments.php');
    exit;
}

$version1 = $comparison['version1'];
$version2 = $comparison['version2'];
$differences = $comparison['differences'];

include '../includes/header.php';
?>

<div class="page-header">
    <h1 class="page-title">🔍 Compare Versions</h1>
    <a href="assessment-versions.php?id=<?php echo $version1['assessment_id']; ?>" class="btn btn-secondary">
        ← Back to Versions
    </a>
</div>

<!-- Version Selection -->
<div class="card" style="margin-bottom: 2rem;">
    <div class="card-body">
        <div style="display: grid; grid-template-columns: 1fr auto 1fr; gap: 2rem; align-items: center;">
            <div style="text-align: center; padding: 1rem; background: rgba(239, 68, 68, 0.1); border-radius: var(--radius-lg);">
                <h3 style="margin: 0 0 0.5rem 0; color: var(--danger);">Version <?php echo $version1['version_number']; ?></h3>
                <div style="font-size: 0.875rem; color: var(--gray-600);">
                    <?php echo date('d/m/Y H:i', strtotime($version1['created_at'])); ?><br>
                    <?php echo htmlspecialchars($version1['created_by_name'] ?? 'System'); ?>
                </div>
            </div>
            
            <div style="font-size: 2rem; color: var(--gray-400);">
                ⟷
            </div>
            
            <div style="text-align: center; padding: 1rem; background: rgba(16, 185, 129, 0.1); border-radius: var(--radius-lg);">
                <h3 style="margin: 0 0 0.5rem 0; color: var(--success);">Version <?php echo $version2['version_number']; ?></h3>
                <div style="font-size: 0.875rem; color: var(--gray-600);">
                    <?php echo date('d/m/Y H:i', strtotime($version2['created_at'])); ?><br>
                    <?php echo htmlspecialchars($version2['created_by_name'] ?? 'System'); ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Summary of Changes -->
<div class="card" style="margin-bottom: 2rem;">
    <div class="card-header">
        <h2 class="card-title">📊 Summary of Changes</h2>
    </div>
    <div class="card-body">
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem;">
            <div style="padding: 1rem; background: var(--gray-50); border-radius: var(--radius-lg);">
                <strong>Risks:</strong><br>
                <span style="color: var(--danger);"><?php echo $differences['risks_count']['old']; ?></span>
                →
                <span style="color: var(--success);"><?php echo $differences['risks_count']['new']; ?></span>
                <?php 
                $riskDiff = $differences['risks_count']['new'] - $differences['risks_count']['old'];
                if ($riskDiff > 0) {
                    echo "<span style='color: var(--success);'>(+{$riskDiff})</span>";
                } elseif ($riskDiff < 0) {
                    echo "<span style='color: var(--danger);'>({$riskDiff})</span>";
                }
                ?>
            </div>
            
            <div style="padding: 1rem; background: var(--gray-50); border-radius: var(--radius-lg);">
                <strong>Actions:</strong><br>
                <span style="color: var(--danger);"><?php echo $differences['actions_count']['old']; ?></span>
                →
                <span style="color: var(--success);"><?php echo $differences['actions_count']['new']; ?></span>
                <?php 
                $actionDiff = $differences['actions_count']['new'] - $differences['actions_count']['old'];
                if ($actionDiff > 0) {
                    echo "<span style='color: var(--success);'>(+{$actionDiff})</span>";
                } elseif ($actionDiff < 0) {
                    echo "<span style='color: var(--danger);'>({$actionDiff})</span>";
                }
                ?>
            </div>
            
            <div style="padding: 1rem; background: var(--gray-50); border-radius: var(--radius-lg);">
                <strong>Field Changes:</strong><br>
                <?php echo count($differences['assessment'] ?? []); ?> fields modified
            </div>
        </div>
    </div>
</div>

<!-- Detailed Changes -->
<?php if (!empty($differences['assessment'])): ?>
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">📝 Field Changes</h2>
        </div>
        <div class="card-body">
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Field</th>
                            <th style="background: rgba(239, 68, 68, 0.1);">Version <?php echo $version1['version_number']; ?></th>
                            <th style="background: rgba(16, 185, 129, 0.1);">Version <?php echo $version2['version_number']; ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($differences['assessment'] as $field => $change): ?>
                            <tr>
                                <td><strong><?php echo ucwords(str_replace('_', ' ', $field)); ?></strong></td>
                                <td style="background: rgba(239, 68, 68, 0.05);">
                                    <?php echo htmlspecialchars($change['old'] ?? 'null'); ?>
                                </td>
                                <td style="background: rgba(16, 185, 129, 0.05);">
                                    <?php echo htmlspecialchars($change['new'] ?? 'null'); ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php else: ?>
    <div class="card">
        <div class="card-body" style="text-align: center; padding: 3rem;">
            <div style="font-size: 4rem; margin-bottom: 1rem;">✨</div>
            <h3>No Changes Detected</h3>
            <p style="color: var(--gray-600);">These versions have identical field values.</p>
        </div>
    </div>
<?php endif; ?>

<?php include '../includes/footer.php'; ?>
