<?php
require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Auth.php';
require_once '../includes/functions.php';

$auth = new Auth();
$auth->requireRole('admin');
$db = Database::getInstance();
$pageTitle = 'Edit User';

$id = $_GET['id'] ?? 0;
$user = $db->fetchOne("SELECT * FROM users WHERE id = ?", [$id]);

if (!$user) {
    setFlashMessage('User not found', 'danger');
    header('Location: users.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $sql = "UPDATE users SET full_name = ?, email = ?, role = ?, active = ? WHERE id = ?";
    $db->query($sql, [
        $_POST['full_name'],
        $_POST['email'],
        $_POST['role'],
        isset($_POST['active']) ? 1 : 0,
        $id
    ]);
    
    if (!empty($_POST['password'])) {
        $hashedPassword = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $db->query("UPDATE users SET password_hash = ? WHERE id = ?", [$hashedPassword, $id]);
    }
    
    logAudit($_SESSION['user_id'], 'update', 'user', $id);
    setFlashMessage('User updated successfully', 'success');
    header('Location: users.php');
    exit;
}

include '../includes/header.php';
?>

<div class="page-header">
    <h1 class="page-title">Edit User</h1>
    <a href="users.php" class="btn btn-secondary">← Back</a>
</div>

<form method="POST">
    <div class="card">
        <div class="card-body">
            <div class="form-group">
                <label class="form-label">Username</label>
                <input type="text" class="form-control" value="<?php echo htmlspecialchars($user['username']); ?>" disabled>
                <small class="form-help">Username cannot be changed</small>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label required">Full Name</label>
                    <input type="text" name="full_name" class="form-control" 
                           value="<?php echo htmlspecialchars($user['full_name']); ?>" required>
                </div>
                <div class="form-group">
                    <label class="form-label required">Email</label>
                    <input type="email" name="email" class="form-control" 
                           value="<?php echo htmlspecialchars($user['email']); ?>" required>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">New Password</label>
                    <input type="password" name="password" class="form-control">
                    <small class="form-help">Leave blank to keep current password</small>
                </div>
                <div class="form-group">
                    <label class="form-label">Role</label>
                    <select name="role" class="form-select">
                        <option value="viewer" <?php echo $user['role'] === 'viewer' ? 'selected' : ''; ?>>Viewer</option>
                        <option value="assessor" <?php echo $user['role'] === 'assessor' ? 'selected' : ''; ?>>Assessor</option>
                        <option value="admin" <?php echo $user['role'] === 'admin' ? 'selected' : ''; ?>>Admin</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label style="display: flex; align-items: center; gap: 0.5rem;">
                    <input type="checkbox" name="active" <?php echo $user['active'] ? 'checked' : ''; ?>>
                    <span>Active</span>
                </label>
            </div>
        </div>
        <div class="card-footer">
            <button type="submit" class="btn btn-primary">Update User</button>
            <a href="users.php" class="btn btn-secondary">Cancel</a>
        </div>
    </div>
</form>

<?php include '../includes/footer.php'; ?>
