<?php
require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Auth.php';
require_once '../includes/functions.php';

$auth = new Auth();
$auth->requireRole('admin');
$db = Database::getInstance();
$pageTitle = 'Create User';

$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    $fullName = $_POST['full_name'] ?? '';
    $role = $_POST['role'] ?? 'viewer';
    
    if (!$username) $errors[] = 'Username is required';
    if (!$email) $errors[] = 'Email is required';
    if (!$password) $errors[] = 'Password is required';
    if (!$fullName) $errors[] = 'Full name is required';
    
    if (empty($errors)) {
        $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
        
        try {
            $sql = "INSERT INTO users (username, email, password, full_name, role) 
                    VALUES (?, ?, ?, ?, ?)";
            $db->query($sql, [$username, $email, $hashedPassword, $fullName, $role]);
            
            logAudit($_SESSION['user_id'], 'create', 'user', $db->lastInsertId());
            setFlashMessage('User created successfully', 'success');
            header('Location: users.php');
            exit;
        } catch (Exception $e) {
            $errors[] = 'Failed to create user: Username or email may already exist';
        }
    }
}

include '../includes/header.php';
?>

<div class="page-header">
    <h1 class="page-title">Create User</h1>
    <a href="users.php" class="btn btn-secondary">← Back</a>
</div>

<?php if (!empty($errors)): ?>
    <div class="alert alert-danger">
        <?php foreach ($errors as $error): ?>
            <div><?php echo htmlspecialchars($error); ?></div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<form method="POST">
    <div class="card">
        <div class="card-body">
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label required">Username</label>
                    <input type="text" name="username" class="form-control" required>
                </div>
                <div class="form-group">
                    <label class="form-label required">Email</label>
                    <input type="email" name="email" class="form-control" required>
                </div>
            </div>
            <div class="form-group">
                <label class="form-label required">Full Name</label>
                <input type="text" name="full_name" class="form-control" required>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label required">Password</label>
                    <input type="password" name="password" class="form-control" required>
                </div>
                <div class="form-group">
                    <label class="form-label required">Role</label>
                    <select name="role" class="form-select" required>
                        <option value="viewer">Viewer</option>
                        <option value="assessor">Assessor</option>
                        <option value="admin">Admin</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="card-footer">
            <button type="submit" class="btn btn-primary">Create User</button>
            <a href="users.php" class="btn btn-secondary">Cancel</a>
        </div>
    </div>
</form>

<?php include '../includes/footer.php'; ?>
