<?php
require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Auth.php';
require_once '../includes/functions.php';
require_once '../includes/AuditManager.php';

$auth = new Auth();
$auth->requireLogin();

$db = Database::getInstance();
$auditManager = new AuditManager();
$pageTitle = 'My Activity';

$userId = $_SESSION['user_id'];

// Get user's activity summary
$activitySummary = $auditManager->getUserActivitySummary($userId, 30);

// Get recent actions
$recentActions = $db->fetchAll(
    "SELECT * FROM audit_log 
     WHERE user_id = ? 
     ORDER BY created_at DESC 
     LIMIT 50",
    [$userId]
);

// Get statistics
$stats30Days = $db->fetchOne(
    "SELECT COUNT(*) as total FROM audit_log 
     WHERE user_id = ? AND created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)",
    [$userId]
);

$stats7Days = $db->fetchOne(
    "SELECT COUNT(*) as total FROM audit_log 
     WHERE user_id = ? AND created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)",
    [$userId]
);

$statsToday = $db->fetchOne(
    "SELECT COUNT(*) as total FROM audit_log 
     WHERE user_id = ? AND DATE(created_at) = CURDATE()",
    [$userId]
);

include '../includes/header.php';
?>

<div class="page-header">
    <h1 class="page-title">📊 My Activity</h1>
</div>

<!-- Activity Statistics -->
<div class="stats-grid" style="margin-bottom: 2rem;">
    <div class="stat-card">
        <div class="stat-card-icon" style="background: linear-gradient(135deg, rgba(99, 102, 241, 0.1), rgba(139, 92, 246, 0.1));">
            📅
        </div>
        <h3>Today</h3>
        <div class="value"><?php echo $statsToday['total'] ?? 0; ?></div>
        <div class="label">Actions</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-card-icon" style="background: linear-gradient(135deg, rgba(16, 185, 129, 0.1), rgba(5, 150, 105, 0.1));">
            📊
        </div>
        <h3>Last 7 Days</h3>
        <div class="value"><?php echo $stats7Days['total'] ?? 0; ?></div>
        <div class="label">Actions</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-card-icon" style="background: linear-gradient(135deg, rgba(245, 158, 11, 0.1), rgba(217, 119, 6, 0.1));">
            📈
        </div>
        <h3>Last 30 Days</h3>
        <div class="value"><?php echo $stats30Days['total'] ?? 0; ?></div>
        <div class="label">Actions</div>
    </div>
</div>

<!-- Activity Summary by Type -->
<div class="card" style="margin-bottom: 2rem;">
    <div class="card-header">
        <h2 class="card-title">Activity Summary (Last 30 Days)</h2>
    </div>
    <div class="card-body">
        <?php if (empty($activitySummary)): ?>
            <p style="text-align: center; padding: 2rem; color: var(--gray-500);">
                No activity in the last 30 days.
            </p>
        <?php else: ?>
            <div style="display: grid; gap: 1rem;">
                <?php foreach ($activitySummary as $activity): ?>
                    <div style="display: flex; justify-content: space-between; align-items: center; padding: 1rem; background: var(--gray-50); border-radius: var(--radius-lg);">
                        <div>
                            <strong><?php echo ucwords(str_replace('_', ' ', $activity['action'])); ?></strong>
                            <span style="color: var(--gray-500);">on</span>
                            <strong><?php echo ucwords(str_replace('_', ' ', $activity['entity_type'])); ?></strong>
                        </div>
                        <div style="display: flex; gap: 2rem; align-items: center;">
                            <div style="text-align: right;">
                                <div style="font-size: 1.5rem; font-weight: 700; color: var(--primary);">
                                    <?php echo $activity['count']; ?>
                                </div>
                                <div style="font-size: 0.75rem; color: var(--gray-500);">times</div>
                            </div>
                            <div style="font-size: 0.875rem; color: var(--gray-600);">
                                Last: <?php echo date('d/m/Y', strtotime($activity['last_activity'])); ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Recent Activity -->
<div class="card">
    <div class="card-header">
        <h2 class="card-title">Recent Activity</h2>
    </div>
    <div class="card-body">
        <?php if (empty($recentActions)): ?>
            <p style="text-align: center; padding: 2rem; color: var(--gray-500);">
                No recent activity to display.
            </p>
        <?php else: ?>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Date/Time</th>
                            <th>Action</th>
                            <th>Entity</th>
                            <th>Details</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($recentActions as $action): ?>
                            <tr>
                                <td>
                                    <small style="display: block;"><?php echo date('d/m/Y', strtotime($action['created_at'])); ?></small>
                                    <small style="color: var(--gray-500);"><?php echo date('H:i:s', strtotime($action['created_at'])); ?></small>
                                </td>
                                <td>
                                    <span class="badge badge-<?php 
                                        echo match($action['action']) {
                                            'create' => 'success',
                                            'update' => 'primary',
                                            'delete' => 'danger',
                                            default => 'secondary'
                                        };
                                    ?>">
                                        <?php echo ucwords(str_replace('_', ' ', $action['action'])); ?>
                                    </span>
                                </td>
                                <td>
                                    <strong><?php echo ucwords(str_replace('_', ' ', $action['entity_type'])); ?></strong>
                                    <?php if ($action['entity_name']): ?>
                                        <br><small style="color: var(--gray-600);"><?php echo htmlspecialchars($action['entity_name']); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($action['changes_summary']): ?>
                                        <small><?php echo htmlspecialchars($action['changes_summary']); ?></small>
                                    <?php else: ?>
                                        <small style="color: var(--gray-400);">—</small>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
