<?php
session_start();
$_SESSION['user_id'] = 1;
$_SESSION['full_name'] = 'Test User';
$_SESSION['role'] = 'admin';

define('APP_NAME', 'Risk Assessment System');
define('SITE_URL', '/public/');

$pageTitle = 'Navigation Test';
include '../includes/header.php';
?>

<div class="page-header">
    <h1 class="page-title">Navigation Link Test</h1>
</div>

<div class="card">
    <div class="card-body">
        <h2>Navigation Links Checklist</h2>
        
        <div style="display: grid; gap: 1rem; margin-top: 1.5rem;">
            <div style="padding: 1rem; background: var(--gray-50); border-radius: var(--radius-lg);">
                <strong>✓ Dashboard</strong> - Should link to dashboard.php
            </div>
            <div style="padding: 1rem; background: var(--gray-50); border-radius: var(--radius-lg);">
                <strong>✓ Assessments</strong> - Should link to assessments.php
            </div>
            <div style="padding: 1rem; background: var(--success-light); border-radius: var(--radius-lg);">
                <strong style="color: var(--success);">✓ Locations</strong> - Should link to locations.php (FIXED!)
            </div>
            <div style="padding: 1rem; background: var(--gray-50); border-radius: var(--radius-lg);">
                <strong>✓ Hazard Library</strong> - Should link to hazard-library.php
            </div>
            <div style="padding: 1rem; background: var(--gray-50); border-radius: var(--radius-lg);">
                <strong>✓ Users</strong> - Should link to users.php (Admin only)
            </div>
            <div style="padding: 1rem; background: var(--gray-50); border-radius: var(--radius-lg);">
                <strong>✓ Settings</strong> - Should link to settings.php (Admin only)
            </div>
        </div>
        
        <div style="margin-top: 2rem; padding: 1rem; background: rgba(59, 130, 246, 0.1); border-left: 4px solid var(--primary); border-radius: var(--radius-lg);">
            <strong>How to verify:</strong><br>
            <ol style="margin-top: 0.5rem; margin-left: 1.5rem;">
                <li>Check that all navigation links in the top menu bar are clickable</li>
                <li>Hover over each link to verify the correct URL appears</li>
                <li>Click each link to verify it navigates to the correct page</li>
                <li>Verify the "Locations" link is between "Assessments" and "Hazard Library"</li>
            </ol>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
