<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Dashboard Test</h1><pre>";

try {
    require_once '../config/config.php';
    echo "✓ Config loaded\n";
    
    require_once '../includes/Database.php';
    echo "✓ Database class loaded\n";
    
    require_once '../includes/Auth.php';
    echo "✓ Auth class loaded\n";
    
    require_once '../includes/functions.php';
    echo "✓ Functions loaded\n";
    
    $db = Database::getInstance();
    echo "✓ Database connected\n";
    
    // Test queries
    $result = $db->fetchOne("SELECT COUNT(*) as count FROM users");
    echo "✓ Users count: " . ($result['count'] ?? 0) . "\n";
    
    $result = $db->fetchOne("SELECT COUNT(*) as count FROM assessments");
    echo "✓ Assessments count: " . ($result['count'] ?? 0) . "\n";
    
    $result = $db->fetchOne("SELECT COUNT(*) as count FROM locations");
    echo "✓ Locations count: " . ($result['count'] ?? 0) . "\n";
    
    echo "\n✅ ALL TESTS PASSED!\n";
    echo "\nYou can now access dashboard.php\n";
    
} catch (Exception $e) {
    echo "❌ ERROR: " . $e->getMessage() . "\n";
    echo "\nStack trace:\n" . $e->getTraceAsString();
}

echo "</pre>";
