<?php
// Simple test page to verify CSS and JS loading
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CSS Test Page</title>
    
    <!-- Test CSS loading with absolute path -->
    <link rel="stylesheet" href="assets/css/style.css">
    
    <style>
        .test-box {
            padding: 2rem;
            margin: 2rem;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="test-box">
        <h1 class="page-title">CSS Loading Test</h1>
        <p>If this text has styling, CSS is loaded correctly!</p>
        
        <div class="card" style="max-width: 600px; margin: 2rem auto;">
            <div class="card-header">
                <h2 class="card-title">Test Card</h2>
            </div>
            <div class="card-body">
                <p>This card should have the modern styling with rounded corners, shadows, and proper colors.</p>
                
                <div style="display: flex; gap: 1rem; margin-top: 1rem; justify-content: center;">
                    <button class="btn btn-primary">Primary Button</button>
                    <button class="btn btn-secondary">Secondary Button</button>
                    <button class="btn btn-danger">Danger Button</button>
                </div>
                
                <div style="margin-top: 1.5rem; display: flex; gap: 0.5rem; justify-content: center;">
                    <span class="badge badge-low">Low</span>
                    <span class="badge badge-medium">Medium</span>
                    <span class="badge badge-high">High</span>
                    <span class="badge badge-critical">Critical</span>
                </div>
            </div>
        </div>
        
        <div style="margin: 2rem auto; max-width: 600px; padding: 1rem; background: white; border-radius: var(--radius-lg); box-shadow: var(--shadow-lg);">
            <h3>CSS Variables Test</h3>
            <p style="color: var(--primary);">This text should be indigo/purple (primary color)</p>
            <p style="color: var(--success);">This text should be green (success color)</p>
            <p style="color: var(--danger);">This text should be red (danger color)</p>
        </div>
        
        <div style="margin-top: 2rem;">
            <a href="login.php" class="btn btn-primary">Go to Login Page</a>
            <a href="dashboard.php" class="btn btn-secondary">Go to Dashboard</a>
        </div>
    </div>
    
    <!-- Test JS loading -->
    <script src="assets/js/main.js"></script>
    
    <script>
        // Verify JS loaded
        console.log('JavaScript loaded successfully!');
        console.log('CSS file location: assets/css/style.css');
        console.log('Body background:', getComputedStyle(document.body).background);
    </script>
</body>
</html>
