<?php
// Force error display
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

echo "<!DOCTYPE html><html><head><title>Error Checker</title></head><body>";
echo "<h1>Error Diagnosis</h1><pre>";

echo "=== Step 1: Loading config.php ===\n";
try {
    require_once '../config/config.php';
    echo "✓ Config loaded successfully\n";
} catch (Throwable $e) {
    echo "✗ Config error: " . $e->getMessage() . "\n";
    die();
}

echo "\n=== Step 2: Loading Database.php ===\n";
try {
    require_once '../includes/Database.php';
    $db = Database::getInstance();
    echo "✓ Database connected\n";
} catch (Throwable $e) {
    echo "✗ Database error: " . $e->getMessage() . "\n";
    die();
}

echo "\n=== Step 3: Loading Auth.php ===\n";
try {
    require_once '../includes/Auth.php';
    $auth = new Auth();
    echo "✓ Auth loaded\n";
} catch (Throwable $e) {
    echo "✗ Auth error: " . $e->getMessage() . "\n";
    echo "Stack: " . $e->getTraceAsString() . "\n";
    die();
}

echo "\n=== Step 4: Loading functions.php ===\n";
try {
    require_once '../includes/functions.php';
    echo "✓ Functions loaded\n";
} catch (Throwable $e) {
    echo "✗ Functions error: " . $e->getMessage() . "\n";
    die();
}

echo "\n=== Step 5: Simulating logged-in session ===\n";
$_SESSION['user_id'] = 1;
$_SESSION['username'] = 'admin';
$_SESSION['role'] = 'admin';

echo "\n=== Step 6: Loading ThemeManager.php ===\n";
try {
    require_once INCLUDES_PATH . '/ThemeManager.php';
    $themeManager = new ThemeManager();
    echo "✓ ThemeManager loaded\n";
} catch (Throwable $e) {
    echo "✗ ThemeManager error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . ":" . $e->getLine() . "\n";
    echo "Stack: " . $e->getTraceAsString() . "\n";
}

echo "\n=== Step 7: Loading header.php ===\n";
$pageTitle = "Test Page";
try {
    ob_start();
    include '../includes/header.php';
    $headerOutput = ob_get_clean();
    echo "✓ Header loaded (output: " . strlen($headerOutput) . " bytes)\n";
} catch (Throwable $e) {
    ob_end_clean();
    echo "✗ Header error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . ":" . $e->getLine() . "\n";
    echo "Stack: " . $e->getTraceAsString() . "\n";
}

echo "\n=== Step 8: Testing dashboard queries ===\n";
try {
    $result = $db->fetchOne("SELECT COUNT(*) as count FROM assessments");
    echo "✓ Assessments query OK: " . $result['count'] . " records\n";
} catch (Throwable $e) {
    echo "✗ Assessments query error: " . $e->getMessage() . "\n";
}

echo "\n=== Step 9: Loading footer.php ===\n";
try {
    ob_start();
    include '../includes/footer.php';
    $footerOutput = ob_get_clean();
    echo "✓ Footer loaded (output: " . strlen($footerOutput) . " bytes)\n";
} catch (Throwable $e) {
    ob_end_clean();
    echo "✗ Footer error: " . $e->getMessage() . "\n";
}

echo "\n";
echo "=== FINAL RESULT ===\n";
echo "If all steps passed, the issue is elsewhere.\n";
echo "Check your web server error logs for more details.\n";

echo "</pre></body></html>";
