<?php
require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Auth.php';
require_once '../includes/functions.php';

$auth = new Auth();
$auth->requireRole('admin');

$db = Database::getInstance();
$pageTitle = 'Settings';

$settings = [];
$settingsData = $db->fetchAll("SELECT * FROM system_settings");
foreach ($settingsData as $setting) {
    $settings[$setting['setting_key']] = $setting['setting_value'];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    foreach ($_POST as $key => $value) {
        if ($key !== 'action') {
            $db->query("INSERT INTO system_settings (setting_key, setting_value) VALUES (?, ?)
                        ON DUPLICATE KEY UPDATE setting_value = ?", [$key, $value, $value]);
        }
    }
    
    logAudit($_SESSION['user_id'], 'update', 'settings', 0);
    setFlashMessage('Settings updated successfully', 'success');
    header('Location: settings.php');
    exit;
}

include '../includes/header.php';
?>

<div class="page-header">
    <h1 class="page-title">⚙️ System Settings</h1>
</div>

<!-- Quick Links -->
<div class="stats-grid" style="margin-bottom: 2rem;">
    <a href="themes.php" style="text-decoration: none;">
        <div class="stat-card" style="cursor: pointer;">
            <div style="font-size: 2rem; margin-bottom: 1rem;">🎨</div>
            <h3>Color Themes</h3>
            <p style="color: var(--gray-600); margin-top: 0.5rem;">Customize colors and appearance</p>
        </div>
    </a>
    <a href="permissions.php" style="text-decoration: none;">
        <div class="stat-card" style="cursor: pointer;">
            <div style="font-size: 2rem; margin-bottom: 1rem;">🔐</div>
            <h3>Permissions</h3>
            <p style="color: var(--gray-600); margin-top: 0.5rem;">Manage role-based access control</p>
        </div>
    </a>
    <a href="pdf-templates.php" style="text-decoration: none;">
        <div class="stat-card" style="cursor: pointer;">
            <div style="font-size: 2rem; margin-bottom: 1rem;">📄</div>
            <h3>PDF Templates</h3>
            <p style="color: var(--gray-600); margin-top: 0.5rem;">Customize export layouts</p>
        </div>
    </a>
</div>

<form method="POST">
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">General Settings</h2>
        </div>
        <div class="card-body">
            <div class="form-group">
                <label class="form-label">Site Name</label>
                <input type="text" name="site_name" class="form-control" 
                       value="<?php echo htmlspecialchars($settings['site_name'] ?? APP_NAME); ?>">
            </div>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Integration Settings</h2>
        </div>
        <div class="card-body">
            <div class="form-group">
                <label class="form-label">Google Maps API Key</label>
                <input type="text" name="google_maps_api_key" class="form-control" 
                       value="<?php echo htmlspecialchars($settings['google_maps_api_key'] ?? ''); ?>">
                <small class="form-help">Get your API key from Google Cloud Console</small>
            </div>
            <div class="form-group">
                <label class="form-label">what3words API Key</label>
                <input type="text" name="what3words_api_key" class="form-control" 
                       value="<?php echo htmlspecialchars($settings['what3words_api_key'] ?? ''); ?>">
                <small class="form-help">Get your API key from what3words Developer Portal</small>
            </div>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Email Notifications</h2>
        </div>
        <div class="card-body">
            <div class="form-group">
                <label style="display: flex; align-items: center; gap: 0.5rem;">
                    <input type="checkbox" name="enable_email_notifications" value="1" 
                           <?php echo ($settings['enable_email_notifications'] ?? '0') == '1' ? 'checked' : ''; ?>>
                    <span>Enable Email Notifications</span>
                </label>
            </div>
            <div class="form-group">
                <label class="form-label">Notification Recipients</label>
                <input type="text" name="notification_emails" class="form-control" 
                       value="<?php echo htmlspecialchars($settings['notification_emails'] ?? ''); ?>">
                <small class="form-help">Comma-separated email addresses</small>
            </div>
        </div>
        <div class="card-footer">
            <button type="submit" class="btn btn-primary btn-lg">💾 Save Settings</button>
        </div>
    </div>
</form>

<?php include '../includes/footer.php'; ?>
