<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<pre>";
echo "=== DIAGNOSTIC SCRIPT ===\n\n";

// Test 1: Config
echo "1. Testing config.php...\n";
if (file_exists('../config/config.php')) {
    require_once '../config/config.php';
    echo "   ✓ config.php loaded\n";
    echo "   DB_HOST: " . (defined('DB_HOST') ? DB_HOST : 'NOT DEFINED') . "\n";
    echo "   DB_NAME: " . (defined('DB_NAME') ? DB_NAME : 'NOT DEFINED') . "\n";
    echo "   BASE_URL: " . (defined('BASE_URL') ? BASE_URL : 'NOT DEFINED') . "\n";
} else {
    die("   ✗ config.php not found!\n");
}

// Test 2: Database
echo "\n2. Testing Database class...\n";
if (file_exists('../includes/Database.php')) {
    require_once '../includes/Database.php';
    echo "   ✓ Database.php loaded\n";
    
    try {
        $db = Database::getInstance();
        echo "   ✓ Database connection successful\n";
        
        // Test query
        $result = $db->fetchOne("SELECT 1 as test");
        if ($result) {
            echo "   ✓ Test query successful\n";
        } else {
            echo "   ✗ Test query returned no results\n";
        }
    } catch (Exception $e) {
        echo "   ✗ Database error: " . $e->getMessage() . "\n";
    }
} else {
    echo "   ✗ Database.php not found!\n";
}

// Test 3: Check tables
echo "\n3. Checking tables...\n";
try {
    $tables = ['users', 'assessments', 'locations', 'audit_log'];
    foreach ($tables as $table) {
        try {
            $result = $db->fetchOne("SELECT COUNT(*) as count FROM $table");
            $count = $result['count'] ?? 'ERROR';
            echo "   ✓ $table: $count records\n";
        } catch (Exception $e) {
            echo "   ✗ $table: " . $e->getMessage() . "\n";
        }
    }
} catch (Exception $e) {
    echo "   ✗ Error checking tables: " . $e->getMessage() . "\n";
}

// Test 4: Auth
echo "\n4. Testing Auth class...\n";
if (file_exists('../includes/Auth.php')) {
    require_once '../includes/Auth.php';
    echo "   ✓ Auth.php loaded\n";
    
    try {
        $auth = new Auth();
        echo "   ✓ Auth class instantiated\n";
    } catch (Exception $e) {
        echo "   ✗ Auth error: " . $e->getMessage() . "\n";
    }
} else {
    echo "   ✗ Auth.php not found!\n";
}

// Test 5: Functions
echo "\n5. Testing functions.php...\n";
if (file_exists('../includes/functions.php')) {
    require_once '../includes/functions.php';
    echo "   ✓ functions.php loaded\n";
    
    // Test a function
    if (function_exists('sanitize')) {
        echo "   ✓ sanitize() function exists\n";
    } else {
        echo "   ✗ sanitize() function not found\n";
    }
} else {
    echo "   ✗ functions.php not found!\n";
}

// Test 6: Session
echo "\n6. Testing session...\n";
if (session_status() === PHP_SESSION_ACTIVE) {
    echo "   ✓ Session active\n";
    echo "   Session ID: " . session_id() . "\n";
} else {
    echo "   ✗ No session active\n";
}

// Test 7: Try to load dashboard
echo "\n7. Testing dashboard.php include chain...\n";
try {
    ob_start();
    
    // Simulate what dashboard does
    $db = Database::getInstance();
    $pageTitle = 'Dashboard';
    
    $stats = [
        'total_assessments' => 0,
        'pending_assessments' => 0,
        'total_locations' => 0,
        'high_risks' => 0
    ];
    
    // Try each query separately
    try {
        $result = $db->fetchOne("SELECT COUNT(*) as count FROM assessments");
        $stats['total_assessments'] = $result['count'] ?? 0;
        echo "   ✓ total_assessments query OK\n";
    } catch (Exception $e) {
        echo "   ✗ total_assessments: " . $e->getMessage() . "\n";
    }
    
    try {
        $result = $db->fetchOne("SELECT COUNT(*) as count FROM assessments WHERE status IN ('draft', 'in_progress')");
        $stats['pending_assessments'] = $result['count'] ?? 0;
        echo "   ✓ pending_assessments query OK\n";
    } catch (Exception $e) {
        echo "   ✗ pending_assessments: " . $e->getMessage() . "\n";
    }
    
    try {
        $result = $db->fetchOne("SELECT COUNT(*) as count FROM locations WHERE active = 1");
        $stats['total_locations'] = $result['count'] ?? 0;
        echo "   ✓ total_locations query OK\n";
    } catch (Exception $e) {
        echo "   ✗ total_locations: " . $e->getMessage() . "\n";
    }
    
    ob_end_clean();
    echo "   ✓ Dashboard logic test passed\n";
    
} catch (Exception $e) {
    ob_end_clean();
    echo "   ✗ Dashboard test failed: " . $e->getMessage() . "\n";
    echo "   Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "\n=== END DIAGNOSTIC ===\n";
echo "</pre>";
