<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Auth.php';
require_once '../includes/functions.php';

$auth = new Auth();
$auth->requireLogin();

$db = Database::getInstance();

// Get statistics
$stats = [
    'total_assessments' => 0,
    'pending_assessments' => 0,
    'total_locations' => 0,
    'high_risks' => 0
];

try {
    $result = $db->fetchOne("SELECT COUNT(*) as count FROM assessments");
    $stats['total_assessments'] = $result['count'] ?? 0;
} catch (Exception $e) {
    // Ignore
}

try {
    $result = $db->fetchOne("SELECT COUNT(*) as count FROM assessments WHERE status IN ('draft', 'in_progress')");
    $stats['pending_assessments'] = $result['count'] ?? 0;
} catch (Exception $e) {
    // Ignore
}

try {
    $result = $db->fetchOne("SELECT COUNT(*) as count FROM locations WHERE active = 1");
    $stats['total_locations'] = $result['count'] ?? 0;
} catch (Exception $e) {
    // Ignore
}

// Recent assessments
$recentAssessments = [];
try {
    $recentAssessments = $db->fetchAll("
        SELECT a.*, l.name as location_name, u.full_name as assessor_name
        FROM assessments a
        LEFT JOIN locations l ON a.location_id = l.id
        LEFT JOIN users u ON a.assessor_id = u.id
        ORDER BY a.created_at DESC
        LIMIT 5
    ");
} catch (Exception $e) {
    // Ignore
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Dashboard - Risk Assessment System</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div style="max-width: 1200px; margin: 0 auto; padding: 20px;">
        <h1>Dashboard (Minimal Version)</h1>
        
        <p>Welcome, <?php echo htmlspecialchars($_SESSION['full_name'] ?? 'User'); ?></p>
        
        <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; margin: 30px 0;">
            <div style="padding: 20px; background: #f0f9ff; border-radius: 8px;">
                <h3>Total Assessments</h3>
                <div style="font-size: 32px; font-weight: bold;"><?php echo $stats['total_assessments']; ?></div>
            </div>
            <div style="padding: 20px; background: #fef3c7; border-radius: 8px;">
                <h3>Pending</h3>
                <div style="font-size: 32px; font-weight: bold;"><?php echo $stats['pending_assessments']; ?></div>
            </div>
            <div style="padding: 20px; background: #d1fae5; border-radius: 8px;">
                <h3>Locations</h3>
                <div style="font-size: 32px; font-weight: bold;"><?php echo $stats['total_locations']; ?></div>
            </div>
            <div style="padding: 20px; background: #fee2e2; border-radius: 8px;">
                <h3>High Risks</h3>
                <div style="font-size: 32px; font-weight: bold;"><?php echo $stats['high_risks']; ?></div>
            </div>
        </div>
        
        <h2>Recent Assessments</h2>
        <table border="1" style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr>
                    <th style="padding: 10px; text-align: left;">Assessment #</th>
                    <th style="padding: 10px; text-align: left;">Location</th>
                    <th style="padding: 10px; text-align: left;">Date</th>
                    <th style="padding: 10px; text-align: left;">Assessor</th>
                    <th style="padding: 10px; text-align: left;">Status</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($recentAssessments)): ?>
                    <tr>
                        <td colspan="5" style="padding: 20px; text-align: center;">
                            No assessments yet. <a href="assessment-create.php">Create your first assessment!</a>
                        </td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($recentAssessments as $assessment): ?>
                        <tr>
                            <td style="padding: 10px;"><?php echo htmlspecialchars($assessment['assessment_number']); ?></td>
                            <td style="padding: 10px;"><?php echo htmlspecialchars($assessment['location_name']); ?></td>
                            <td style="padding: 10px;"><?php echo htmlspecialchars($assessment['visit_date']); ?></td>
                            <td style="padding: 10px;"><?php echo htmlspecialchars($assessment['assessor_name']); ?></td>
                            <td style="padding: 10px;"><?php echo htmlspecialchars($assessment['status']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
        
        <div style="margin-top: 30px;">
            <p><strong>Navigation:</strong></p>
            <ul>
                <li><a href="assessments.php">View All Assessments</a></li>
                <li><a href="assessment-create.php">Create New Assessment</a></li>
                <li><a href="locations.php">Manage Locations</a></li>
                <li><a href="hazard-library.php">Hazard Library</a></li>
                <li><a href="logout.php">Logout</a></li>
            </ul>
        </div>
        
        <div style="margin-top: 20px; padding: 15px; background: #fff3cd; border-radius: 8px;">
            <strong>Note:</strong> This is a minimal dashboard without the full theme system.
            If this works, the issue is in header.php or ThemeManager.php.
            Use <a href="show-errors.php">show-errors.php</a> to diagnose the exact issue.
        </div>
    </div>
</body>
</html>
