<?php
require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Auth.php';
require_once '../includes/functions.php';
require_once '../includes/PDFTemplateManager.php';

$auth = new Auth();
$auth->requireLogin();

$db = Database::getInstance();
$pdfManager = new PDFTemplateManager();

$id = $_GET['id'] ?? 0;
$templateId = $_GET['template'] ?? null;

// Get assessment with all details
$sql = "SELECT a.*, l.*, 
        a.id as assessment_id,
        l.name as location_name,
        u.full_name as assessor_name
        FROM assessments a
        LEFT JOIN locations l ON a.location_id = l.id
        LEFT JOIN users u ON a.assessor_id = u.id
        WHERE a.id = ?";

$assessment = $db->fetchOne($sql, [$id]);

if (!$assessment) {
    die('Assessment not found');
}

// Get risks
$risks = $db->fetchAll("
    SELECT ar.*
    FROM assessment_risks ar
    WHERE ar.assessment_id = ?
    ORDER BY ar.risk_score DESC
", [$id]);

// Get action items
$actions = $db->fetchAll("
    SELECT ai.*, u.full_name as assigned_to_name
    FROM action_items ai
    LEFT JOIN users u ON ai.assigned_to = u.id
    WHERE ai.assessment_id = ?
", [$id]);

// Generate PDF HTML
try {
    $html = $pdfManager->generatePDFHTML($assessment, $risks, $actions, $templateId);
    echo $html;
} catch (Exception $e) {
    die('Error generating PDF: ' . $e->getMessage());
}
