<?php
require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Auth.php';
require_once '../includes/functions.php';

$auth = new Auth();
$auth->requireLogin();
$db = Database::getInstance();
$pageTitle = 'Edit Assessment';

$id = $_GET['id'] ?? 0;
$assessment = $db->fetchOne("SELECT * FROM assessments WHERE id = ?", [$id]);

if (!$assessment || $assessment['is_locked']) {
    setFlashMessage('Assessment not found or locked', 'danger');
    header('Location: assessments.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $sql = "UPDATE assessments SET 
            title = ?, 
            description = ?, 
            delivery_type = ?, 
            vehicle_type = ?, 
            weather_conditions = ?, 
            status = ?,
            updated_by = ?,
            updated_at = NOW()
            WHERE id = ?";
    
    $db->query($sql, [
        $_POST['title'],
        $_POST['description'],
        $_POST['delivery_type'],
        $_POST['vehicle_type'],
        $_POST['weather_conditions'],
        $_POST['status'],
        $_SESSION['user_id'],  // updated_by
        $id
    ]);
    
    logAudit($_SESSION['user_id'], 'update', 'assessment', $id);
    setFlashMessage('Assessment updated successfully', 'success');
    header('Location: assessment-view.php?id=' . $id);
    exit;
}

$locations = $db->fetchAll("SELECT * FROM locations WHERE active = 1 ORDER BY name");
include '../includes/header.php';
?>

<div class="page-header">
    <h1 class="page-title">Edit Assessment</h1>
    <a href="assessment-view.php?id=<?php echo $id; ?>" class="btn btn-secondary">← Back</a>
</div>

<form method="POST">
    <div class="card">
        <div class="card-body">
            <div class="form-group">
                <label class="form-label">Title</label>
                <input type="text" name="title" class="form-control" 
                       value="<?php echo htmlspecialchars($assessment['title']); ?>" required>
            </div>
            <div class="form-group">
                <label class="form-label">Description</label>
                <textarea name="description" class="form-textarea"><?php echo htmlspecialchars($assessment['description']); ?></textarea>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Delivery Type</label>
                    <input type="text" name="delivery_type" class="form-control" 
                           value="<?php echo htmlspecialchars($assessment['delivery_type']); ?>">
                </div>
                <div class="form-group">
                    <label class="form-label">Vehicle Type</label>
                    <input type="text" name="vehicle_type" class="form-control" 
                           value="<?php echo htmlspecialchars($assessment['vehicle_type']); ?>">
                </div>
                <div class="form-group">
                    <label class="form-label">Weather</label>
                    <input type="text" name="weather_conditions" class="form-control" 
                           value="<?php echo htmlspecialchars($assessment['weather_conditions']); ?>">
                </div>
            </div>
            <div class="form-group">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="draft" <?php echo $assessment['status'] === 'draft' ? 'selected' : ''; ?>>Draft</option>
                    <option value="in_progress" <?php echo $assessment['status'] === 'in_progress' ? 'selected' : ''; ?>>In Progress</option>
                    <option value="completed" <?php echo $assessment['status'] === 'completed' ? 'selected' : ''; ?>>Completed</option>
                </select>
            </div>
        </div>
        <div class="card-footer">
            <button type="submit" class="btn btn-primary">Update Assessment</button>
            <a href="assessment-view.php?id=<?php echo $id; ?>" class="btn btn-secondary">Cancel</a>
        </div>
    </div>
</form>

<?php include '../includes/footer.php'; ?>
