<?php
require_once '../../config/config.php';
require_once '../../includes/Database.php';
require_once '../../includes/Auth.php';
require_once '../../includes/PhotoUpload.php';

header('Content-Type: application/json');

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

if (!isset($_FILES['photo']) || !isset($_POST['assessment_id']) || !isset($_POST['item_id'])) {
    echo json_encode(['success' => false, 'message' => 'Missing required parameters']);
    exit;
}

$photoUpload = new PhotoUpload();
$result = $photoUpload->upload($_FILES['photo'], $_POST['assessment_id'], $_POST['item_id']);

echo json_encode($result);
