<?php
require_once '../../config/config.php';
require_once '../../includes/Database.php';
require_once '../../includes/Auth.php';
require_once '../../includes/HazardLibrary.php';

header('Content-Type: application/json');

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasPermission('assessments', 'update')) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

if (!isset($_FILES['photo']) || !isset($_POST['hazard_id'])) {
    echo json_encode(['success' => false, 'message' => 'Missing required fields']);
    exit;
}

try {
    $hazardLib = new HazardLibrary();
    $result = $hazardLib->uploadPhoto(
        $_FILES['photo'],
        $_POST['hazard_id'],
        $_POST['caption'] ?? null,
        isset($_POST['is_primary']) && $_POST['is_primary'] == '1'
    );
    
    echo json_encode([
        'success' => true,
        'photo' => $result
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
