<?php
require_once '../../config/config.php';
require_once '../../includes/Database.php';
require_once '../../includes/Auth.php';
require_once '../../includes/ThemeManager.php';

header('Content-Type: application/json');

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['theme_id'])) {
    echo json_encode(['success' => false, 'message' => 'Theme ID required']);
    exit;
}

try {
    $themeManager = new ThemeManager();
    $themeManager->setUserTheme($_SESSION['user_id'], $input['theme_id']);
    
    echo json_encode(['success' => true, 'message' => 'Theme applied successfully']);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
