<?php
require_once '../../config/config.php';
require_once '../../includes/Database.php';
require_once '../../includes/Auth.php';
require_once '../../includes/HazardLibrary.php';

header('Content-Type: application/json');

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$categoryId = $_GET['category'] ?? null;
$searchTerm = $_GET['search'] ?? null;

try {
    $hazardLib = new HazardLibrary();
    $hazards = $hazardLib->getHazards($categoryId, $searchTerm, true);
    
    echo json_encode([
        'success' => true,
        'hazards' => $hazards
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
