<?php
require_once '../../config/config.php';
require_once '../../includes/Database.php';
require_once '../../includes/Auth.php';
require_once '../../includes/PhotoUpload.php';

header('Content-Type: application/json');

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['filename']) || !isset($input['item_id'])) {
    echo json_encode(['success' => false, 'message' => 'Missing required parameters']);
    exit;
}

$photoUpload = new PhotoUpload();

if ($photoUpload->removePhotoFromItem($input['item_id'], $input['filename'])) {
    $photoUpload->delete($input['filename']);
    echo json_encode(['success' => true, 'message' => 'Photo deleted successfully']);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to delete photo']);
}
