<?php
require_once '../../config/config.php';
require_once '../../includes/Database.php';
require_once '../../includes/Auth.php';
require_once '../../includes/HazardLibrary.php';

header('Content-Type: application/json');

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasPermission('assessments', 'delete')) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['hazard_id'])) {
    echo json_encode(['success' => false, 'message' => 'Hazard ID required']);
    exit;
}

try {
    $hazardLib = new HazardLibrary();
    $hazardLib->deleteHazard($input['hazard_id']);
    
    echo json_encode(['success' => true]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
