<?php
require_once '../../config/config.php';
require_once '../../includes/Database.php';
require_once '../../includes/Auth.php';
require_once '../../includes/HazardLibrary.php';

header('Content-Type: application/json');

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasPermission('assessments', 'update')) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

// Handle both GET and POST
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $hazardId = $_GET['hazard'] ?? null;
    $assessmentId = $_GET['assessment'] ?? null;
} else {
    $input = json_decode(file_get_contents('php://input'), true);
    $hazardId = $input['hazard_id'] ?? null;
    $assessmentId = $input['assessment_id'] ?? null;
}

if (!$hazardId || !$assessmentId) {
    echo json_encode(['success' => false, 'message' => 'Missing required parameters']);
    exit;
}

try {
    $hazardLib = new HazardLibrary();
    $riskId = $hazardLib->addToAssessment($hazardId, $assessmentId);
    
    echo json_encode([
        'success' => true,
        'risk_id' => $riskId,
        'message' => 'Hazard added to assessment successfully'
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
