<?php
/**
 * Photo Upload Component
 * Displays photo upload interface and existing photos for a risk item
 * 
 * Required variables:
 * - $itemId: The assessment_risks.id
 * - $assessmentId: The assessments.id
 * - $photos: Array of photos from PhotoUpload::getPhotos()
 */

if (!isset($itemId) || !isset($assessmentId)) {
    return;
}

// Get photos if not provided
if (!isset($photos)) {
    require_once __DIR__ . '/../PhotoUpload.php';
    $photoUpload = new PhotoUpload();
    $photos = $photoUpload->getPhotos($itemId);
}
?>

<div class="photo-upload-section" style="margin-top: 15px; padding: 15px; background: #f8f9fa; border-radius: 8px;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
        <h4 style="margin: 0; font-size: 14px; font-weight: 600;">📷 Photos</h4>
        <label class="btn btn-sm btn-primary" style="cursor: pointer; font-size: 13px; padding: 6px 12px;">
            <input type="file" 
                   class="photo-upload-input" 
                   data-assessment-id="<?php echo htmlspecialchars($assessmentId); ?>" 
                   data-item-id="<?php echo htmlspecialchars($itemId); ?>"
                   accept="image/jpeg,image/jpg,image/png,image/gif,image/webp"
                   style="display: none;">
            Add Photo
        </label>
    </div>
    
    <div class="photo-upload-container">
        <?php if (empty($photos)): ?>
            <p style="margin: 0; color: #6c757d; font-size: 13px;">No photos attached. Click "Add Photo" to upload.</p>
        <?php else: ?>
            <div class="photo-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(120px, 1fr)); gap: 10px; margin-top: 10px;">
                <?php foreach ($photos as $photo): ?>
                    <div class="photo-item" style="position: relative; border-radius: 8px; overflow: hidden; aspect-ratio: 1;">
                        <a href="<?php echo htmlspecialchars($photo['url']); ?>" target="_blank" style="display: block;">
                            <img src="<?php echo htmlspecialchars($photo['thumbnail']); ?>" 
                                 alt="Risk photo" 
                                 style="width: 100%; height: 100%; object-fit: cover; border-radius: 8px; transition: transform 0.2s;"
                                 onmouseover="this.style.transform='scale(1.05)'"
                                 onmouseout="this.style.transform='scale(1)'">
                        </a>
                        <button type="button" 
                                class="photo-delete" 
                                data-filename="<?php echo htmlspecialchars($photo['filename']); ?>" 
                                data-item-id="<?php echo htmlspecialchars($itemId); ?>"
                                style="position: absolute; top: 5px; right: 5px; background: rgba(220, 38, 38, 0.9); color: white; border: none; border-radius: 50%; width: 24px; height: 24px; cursor: pointer; font-size: 14px; line-height: 1; padding: 0; display: flex; align-items: center; justify-content: center; transition: background 0.2s;"
                                onmouseover="this.style.background='rgba(220, 38, 38, 1)'"
                                onmouseout="this.style.background='rgba(220, 38, 38, 0.9)'"
                                title="Delete photo">
                            ×
                        </button>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
.photo-item img:hover {
    transform: scale(1.05);
}

.photo-delete:hover {
    background: rgba(220, 38, 38, 1) !important;
}

.spinner {
    border: 3px solid #f3f3f3;
    border-top: 3px solid #2563eb;
    border-radius: 50%;
    width: 30px;
    height: 30px;
    animation: spin 1s linear infinite;
    margin: 20px auto;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.loading {
    text-align: center;
    padding: 20px;
}
</style>
