<?php
if (!isset($pageTitle)) {
    $pageTitle = APP_NAME;
}

// Load user theme (if tables exist)
$themeCSS = '';
if (isset($_SESSION['user_id'])) {
    try {
        require_once INCLUDES_PATH . '/ThemeManager.php';
        $themeManager = new ThemeManager();
        $userTheme = $themeManager->getUserTheme($_SESSION['user_id']);
        if ($userTheme) {
            $themeCSS = $themeManager->generateCSS($userTheme);
        }
    } catch (Exception $e) {
        // Theme tables don't exist yet, continue without custom theme
        error_log('Theme error: ' . $e->getMessage());
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle); ?> - <?php echo APP_NAME; ?></title>
    
    <!-- Modern CSS -->
    <link rel="stylesheet" href="<?php echo SITE_URL; ?>assets/css/style.css">
    
    <!-- User Theme Override -->
    <?php if ($themeCSS): ?>
    <style><?php echo $themeCSS; ?></style>
    <?php endif; ?>
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="<?php echo SITE_URL; ?>manifest.json">
    
    <!-- Theme Color -->
    <meta name="theme-color" content="#6366f1">
    
    <!-- Favicon -->
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'><text y='.9em' font-size='90'>🛡️</text></svg>">
</head>
<body>
    <nav class="navbar">
        <div class="navbar-brand">
            <span style="font-size: 1.5rem;">🛡️</span>
            <?php echo APP_NAME; ?>
        </div>
        <div class="nav-links">
            <a href="<?php echo SITE_URL; ?>dashboard.php" class="nav-link">
                Dashboard
            </a>
            <a href="<?php echo SITE_URL; ?>assessments.php" class="nav-link">
                Assessments
            </a>
            <a href="<?php echo SITE_URL; ?>locations.php" class="nav-link">
                Locations
            </a>
            <a href="<?php echo SITE_URL; ?>hazard-library.php" class="nav-link">
                Hazard Library
            </a>
            <?php if (isset($_SESSION['role']) && $_SESSION['role'] === 'admin'): ?>
                <a href="<?php echo SITE_URL; ?>users.php" class="nav-link">
                    Users
                </a>
                <a href="<?php echo SITE_URL; ?>settings.php" class="nav-link">
                    Settings
                </a>
                <a href="<?php echo SITE_URL; ?>audit-logs.php" class="nav-link">
                    Audit Logs
                </a>
            <?php endif; ?>
            <div style="padding: 0 0.5rem; color: var(--gray-400);">|</div>
            <div style="padding: 0.5rem 1rem; font-size: 0.875rem; color: var(--gray-600);">
                <?php echo htmlspecialchars($_SESSION['full_name'] ?? 'User'); ?>
                <span style="color: var(--gray-400);">(<?php echo ucfirst($_SESSION['role'] ?? 'viewer'); ?>)</span>
            </div>
            <a href="<?php echo SITE_URL; ?>logout.php" class="btn btn-danger btn-sm">
                Logout
            </a>
        </div>
    </nav>
    
    <div class="page-wrapper">
        <div class="container">
            <?php if ($flash = getFlashMessage()): ?>
                <div class="alert alert-<?php echo $flash['type']; ?>">
                    <div><?php echo htmlspecialchars($flash['message']); ?></div>
                </div>
            <?php endif; ?>
