<?php
/**
 * Authentication Class
 */

class Auth {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function login($username, $password) {
        $sql = "SELECT * FROM users WHERE username = ? AND active = 1";
        $user = $this->db->fetchOne($sql, [$username]);
        
        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['full_name'] = $user['full_name'];
            $_SESSION['role'] = $user['role'];
            $_SESSION['last_activity'] = time();
            
            // Update last login
            $this->db->query("UPDATE users SET last_login = NOW() WHERE id = ?", [$user['id']]);
            
            return true;
        }
        
        return false;
    }
    
    public function logout() {
        session_destroy();
        session_start();
    }
    
    public function isLoggedIn() {
        if (!isset($_SESSION['user_id'])) {
            return false;
        }
        
        // Check session timeout
        if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > SESSION_LIFETIME)) {
            $this->logout();
            return false;
        }
        
        $_SESSION['last_activity'] = time();
        return true;
    }
    
    public function requireLogin() {
        if (!$this->isLoggedIn()) {
            header('Location: ' . SITE_URL . 'login.php');
            exit;
        }
    }
    
    public function requireRole($roles) {
        $this->requireLogin();
        $roles = is_array($roles) ? $roles : [$roles];
        
        if (!in_array($_SESSION['role'], $roles)) {
            header('Location: ' . SITE_URL . 'dashboard.php');
            exit;
        }
    }
    
    public function hasPermission($resource, $action) {
        if (!isset($_SESSION['role'])) {
            return false;
        }
        
        $sql = "SELECT can_{$action} FROM permissions WHERE role = ? AND resource = ?";
        $result = $this->db->fetchOne($sql, [$_SESSION['role'], $resource]);
        
        return $result && $result["can_{$action}"] == 1;
    }
}
